/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import mondrian.gui.I18n;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.PreferencesSchemasDialog;
import mondrian.gui.Workbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesDialog
extends JPanel {
    boolean accepted = false;
    Workbench workbench = null;
    String previousUrl = null;
    String previousDbHost = null;
    String previousDbPort = null;
    String previousDbName = null;
    static String defaultConnectionNameIndicator = null;
    static String unspecifiedDatabaseTypeName = null;
    private JComboBox conNameList;
    private Map<String, Workbench.ConnectionDetails> connectionDetailsMap;
    private Map dbTypeMap;
    private JCheckBox setDefault;
    private JTextField driverClassTextField;
    private JPanel jPanel1;
    private JPanel dbPanel;
    private JTextField urlTextField;
    private JComboBox dbTypeList;
    private JTextField dbHostTextField;
    private JTextField dbPortTextField;
    private JTextField dbNameTextField;
    private JTextField schemaTextField;
    private JTextField usernameTextField;
    private JTextField passwordTextField;
    private JCheckBox requireSchemaButton;
    private JButton selectSchemasButton;
    private JButton saveButton;
    private JButton testButton;
    private JButton deleteButton;
    private JTabbedPane jTabbedPane1;
    private JButton cancelButton;
    private JButton closeButton;
    private JLabel jLabel6;
    private JLabel jLabel5;
    private JLabel jLabel4;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JLabel jLabel0;
    private JLabel dbTypeLabel;
    private JLabel dbHostLabel;
    private JLabel dbPortLabel;
    private JLabel dbNameLabel;

    public PreferencesDialog(Workbench parent) {
        this.workbench = parent;
        this.initComponents();
    }

    public boolean accepted() {
        return this.accepted;
    }

    public void setDefault(String s) {
        this.setDefault.setSelected(Boolean.parseBoolean(s));
    }

    public boolean getDefault() {
        return this.setDefault.isSelected();
    }

    public void setJdbcConnectionUrl() {
        String dbType = (String)this.dbTypeList.getSelectedItem();
        if (dbType == null) {
            return;
        }
        JdbcConnectionConfiguration dbt = (JdbcConnectionConfiguration)this.dbTypeMap.get(dbType);
        if (dbt != null && !dbType.equals(PreferencesDialog.getUnspecifiedDatabaseTypeName())) {
            this.setJdbcConnectionUrl(dbt.getUrl());
        }
    }

    public void setJdbcConnectionUrl(String s) {
        this.urlTextField.setText(s);
    }

    public void resetJdbcConnectionUrl() {
        this.previousUrl = "";
        this.urlTextField.setText("");
    }

    public String getJdbcConnectionUrl() {
        return this.urlTextField.getText();
    }

    public void setJdbcUsername(String s) {
        this.usernameTextField.setText(s);
    }

    public String getJdbcUsername() {
        return this.usernameTextField.getText();
    }

    public void setJdbcPassword(String s) {
        this.passwordTextField.setText(s);
    }

    public String getJdbcPassword() {
        return this.passwordTextField.getText();
    }

    public JdbcConnectionConfiguration getCurrentDbType() {
        String dbType = (String)this.dbTypeList.getSelectedItem();
        if (dbType == null) {
            return null;
        }
        return (JdbcConnectionConfiguration)this.dbTypeMap.get(dbType);
    }

    public void setJdbcDriverClassName() {
        JdbcConnectionConfiguration dbt = this.getCurrentDbType();
        if (dbt != null && !dbt.typeName.equals(PreferencesDialog.getUnspecifiedDatabaseTypeName())) {
            this.setJdbcDriverClassName(dbt.getDriver());
        }
    }

    public void setJdbcDriverClassName(String className) {
        this.driverClassTextField.setText(className);
    }

    public void resetJdbcDriverClassName() {
        this.driverClassTextField.setText("");
    }

    public String getJdbcDriverClassName() {
        return this.driverClassTextField.getText();
    }

    public void setDatabaseSchema(String schema) {
        this.schemaTextField.setText(schema);
    }

    public String getDatabaseSchema() {
        return this.schemaTextField.getText();
    }

    public void resetDatabaseSchema() {
        this.schemaTextField.setText("");
    }

    public void setRequireSchema(boolean requireSchema) {
        this.requireSchemaButton.setSelected(requireSchema);
    }

    public boolean getRequireSchema() {
        return this.requireSchemaButton.isSelected();
    }

    public I18n getResourceConverter() {
        if (this.workbench == null || this.workbench.getClass() != Workbench.class) {
            return Workbench.getGlobalResourceConverter();
        }
        return this.workbench.getResourceConverter();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.dbPanel = new JPanel();
        this.jLabel0 = new JLabel();
        this.dbTypeLabel = new JLabel();
        this.dbHostLabel = new JLabel();
        this.dbPortLabel = new JLabel();
        this.dbNameLabel = new JLabel();
        this.conNameList = new JComboBox();
        this.setDefault = new JCheckBox(this.getResourceConverter().getString("preferences.default.connection.title", "Default Connection"));
        this.driverClassTextField = new JTextField(20);
        this.dbHostTextField = new JTextField(10);
        this.dbPortTextField = new JTextField(10);
        this.dbNameTextField = new JTextField(10);
        this.dbHostTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent f) {
            }

            public void focusLost(FocusEvent f) {
                PreferencesDialog.this.dbHostTextFieldFocusLost();
            }
        });
        this.dbPortTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent f) {
            }

            public void focusLost(FocusEvent f) {
                PreferencesDialog.this.dbPortTextFieldFocusLost();
            }
        });
        this.dbNameTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent f) {
            }

            public void focusLost(FocusEvent f) {
                PreferencesDialog.this.dbNameTextFieldFocusLost();
            }
        });
        this.urlTextField = new JTextField(40);
        this.urlTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent f) {
            }

            public void focusLost(FocusEvent f) {
                PreferencesDialog.this.urlTextFieldFocusLost();
            }
        });
        this.usernameTextField = new JTextField();
        this.passwordTextField = new JPasswordField();
        this.schemaTextField = new JTextField();
        this.requireSchemaButton = new JCheckBox();
        this.testButton = new JButton();
        this.saveButton = new JButton();
        this.deleteButton = new JButton();
        this.cancelButton = new JButton();
        this.selectSchemasButton = new JButton();
        this.closeButton = new JButton();
        this.dbTypeList = new JComboBox();
        this.setDbTypeList();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.dbPanel.setLayout(new GridBagLayout());
        this.jLabel0.setText(this.getResourceConverter().getString("preferences.connectionName.title", "Connection Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel0, gridBagConstraints);
        this.dbTypeLabel.setText(this.getResourceConverter().getString("preferences.databaseType.title", "Database Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dbPanel.add((Component)this.dbTypeLabel, gridBagConstraints);
        this.jLabel1.setText(this.getResourceConverter().getString("preferences.driverClassName.title", "Driver Class Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dbPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.dbHostLabel.setText(this.getResourceConverter().getString("preferences.databaseHost.title", "Database Host"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dbPanel.add((Component)this.dbHostLabel, gridBagConstraints);
        this.dbPortLabel.setText(this.getResourceConverter().getString("preferences.databasePort.title", "Database Port"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dbPanel.add((Component)this.dbPortLabel, gridBagConstraints);
        this.dbNameLabel.setText(this.getResourceConverter().getString("preferences.databaseName.title", "Database Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dbPanel.add((Component)this.dbNameLabel, gridBagConstraints);
        this.jLabel6.setText(this.getResourceConverter().getString("preferences.connectionURL.title", "Connection URL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dbPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.dbTypeList.setPreferredSize(null);
        this.dbTypeList.setMinimumSize(this.dbTypeList.getPreferredSize());
        this.dbTypeList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.dbTypeListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dbPanel.add((Component)this.dbTypeList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dbPanel.add((Component)this.driverClassTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dbPanel.add((Component)this.dbHostTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dbPanel.add((Component)this.dbPortTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dbPanel.add((Component)this.dbNameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dbPanel.add((Component)this.urlTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dbPanel.setBorder(BorderFactory.createTitledBorder(this.getResourceConverter().getString("preferences.database.panel.title", "Database")));
        this.jPanel1.add((Component)this.dbPanel, gridBagConstraints);
        this.jLabel3.setText(this.getResourceConverter().getString("preferences.userName.title", "User name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText(this.getResourceConverter().getString("preferences.password.title", "Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel2.setText(this.getResourceConverter().getString("preferences.schema.title", "Schema (Optional,\ncomma separated)"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel5.setText(this.getResourceConverter().getString("preferences.requireschema.title", "Require Schema Attributes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.conNameList.setEditable(true);
        this.conNameList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.conNameListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.conNameList, gridBagConstraints);
        this.usernameTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.usernameTextField, gridBagConstraints);
        this.passwordTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.passwordTextField, gridBagConstraints);
        this.schemaTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.schemaTextField.setEditable(false);
        this.jPanel1.add((Component)this.schemaTextField, gridBagConstraints);
        this.selectSchemasButton.setText(this.getResourceConverter().getString("preferences.selectSchemasButton.title", "Select Schemas"));
        this.selectSchemasButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.selectSchemasButtonActionPerformed(evt);
            }
        });
        this.requireSchemaButton.setSelected(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.requireSchemaButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.setDefault, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.selectSchemasButton, gridBagConstraints);
        this.jTabbedPane1.addTab(this.getResourceConverter().getString("preferences.jdbcPanel.title", "Jdbc"), this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jTabbedPane1, gridBagConstraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.deleteButton.setText(this.getResourceConverter().getString("preferences.deleteButton.title", "Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.deleteButton);
        this.cancelButton.setText(this.getResourceConverter().getString("preferences.cancelButton.title", "Clear"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.cancelButton);
        this.testButton.setText(this.getResourceConverter().getString("preferences.testButton.title", "Test"));
        this.testButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.testButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.testButton);
        this.saveButton.setText(this.getResourceConverter().getString("preferences.saveButton.title", "Save"));
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.saveButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.saveButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)buttonPanel, gridBagConstraints);
        Workbench.setPreferredSizeMaxXY(this.saveButton, this.testButton, this.deleteButton, this.cancelButton);
        this.updateConNameList(this.workbench.getConnectionDetailsMap(), null);
    }

    private void selectSchemasButtonActionPerformed(ActionEvent evt) {
        JdbcMetaData jdbcMetaData = this.getTestingJdbcMetadata();
        if (jdbcMetaData.getErrMsg() != null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("preferences.unsuccessfulTestConnection.alert", "Database connection could not be done.\n{0}", jdbcMetaData.getErrMsg()), "", 2);
            return;
        }
        List<String> allSchemaNames = jdbcMetaData.listAllSchemas();
        if (allSchemaNames == null || allSchemaNames.size() == 0) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("preferences.noSchemas.cantSetSchemas.alert", "No schemas available for this database connection"), "", 2);
            return;
        }
        PreferencesSchemasDialog psd = new PreferencesSchemasDialog(this, jdbcMetaData);
        if (psd.isAccepted()) {
            this.setDatabaseSchema(psd.selectedSchemaString);
        }
    }

    public JdbcMetaData getTestingJdbcMetadata() {
        return new JdbcMetaData(this.getJdbcDriverClassName(), this.getJdbcConnectionUrl(), this.getJdbcUsername(), this.getJdbcPassword());
    }

    private void testButtonActionPerformed(ActionEvent evt) {
        JdbcMetaData jdbcMetaData = this.getTestingJdbcMetadata();
        if (jdbcMetaData.getErrMsg() != null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("preferences.unsuccessfulTestConnection.alert", "Database connection could not be done.\n{0}", jdbcMetaData.getErrMsg()), "", 2);
            this.accepted = false;
            return;
        }
        List<String> allSchemaNames = jdbcMetaData.listAllSchemas();
        String currentSchemas = this.schemaTextField.getText();
        if (allSchemaNames == null || allSchemaNames.size() == 0) {
            if (currentSchemas != null && currentSchemas.trim().length() > 0) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("preferences.noSchemas.butSchemasEntered.alert", "No schemas available for this database connection, but schemas entered"), "", 2);
                this.accepted = false;
                return;
            }
            if (this.requireSchemaButton.isSelected()) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("preferences.noSchemas.butSchemasRequired.alert", "No schemas available for this database connection, but schemas are required"), "", 2);
                this.accepted = false;
                return;
            }
        }
        if (currentSchemas != null && currentSchemas.trim().length() > 0) {
            String[] schemasArray = currentSchemas.trim().split("[,;]");
            TreeSet<String> validSchemas = new TreeSet<String>();
            StringBuffer schemasInError = new StringBuffer();
            for (int i = 0; i < schemasArray.length; ++i) {
                String enteredSchemaName = schemasArray[i].trim();
                if (enteredSchemaName.length() > 0) {
                    for (String actualSchemaName : allSchemaNames) {
                        if (!actualSchemaName.equalsIgnoreCase(enteredSchemaName)) continue;
                        validSchemas.add(enteredSchemaName);
                        break;
                    }
                }
                if (validSchemas.contains(enteredSchemaName)) continue;
                schemasInError.append(" ").append(enteredSchemaName);
            }
            if (schemasInError.length() > 0) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("preferences.invalidSchemas.alert", "The following entered schemas are invalid.\n{0}", schemasInError.toString()), "", 2);
                this.accepted = false;
                return;
            }
        }
        JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("preferences.successfulTestConnection.alert", "Database connection successful"), "", 1);
        this.accepted = true;
    }

    private void dbTypeListActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("comboBoxChanged")) {
            this.setJdbcDriverClassName();
        }
    }

    public static String getDefaultConnectionNameIndicator() {
        if (defaultConnectionNameIndicator == null) {
            defaultConnectionNameIndicator = Workbench.getGlobalResourceConverter().getString("preferences.defaultConnection.suffix", " - Default");
        }
        return defaultConnectionNameIndicator;
    }

    public static String getUnspecifiedDatabaseTypeName() {
        if (unspecifiedDatabaseTypeName == null) {
            unspecifiedDatabaseTypeName = Workbench.getGlobalResourceConverter().getString("preferences.other.database.type.title", "Other");
        }
        return unspecifiedDatabaseTypeName;
    }

    public static String getConnectionNameFromListName(String listName) {
        if (listName != null) {
            int index = listName.indexOf(PreferencesDialog.getDefaultConnectionNameIndicator());
            if (index != -1) {
                listName = listName.substring(0, index);
            }
            return listName.trim();
        }
        return listName;
    }

    private void conNameListActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("comboBoxChanged")) {
            JComboBox cb = (JComboBox)evt.getSource();
            this.updateDatabasePanel(PreferencesDialog.getConnectionNameFromListName((String)cb.getSelectedItem()));
        }
    }

    private void updateDatabasePanel(String conName) {
        Workbench.ConnectionDetails cd = this.getConnectionDetailsMap().get(conName);
        if (cd != null) {
            this.setDefault(Boolean.toString(cd.defaultConnection));
            this.setJdbcDriverClassName(cd.driverClassName);
            this.dbHostTextField.setText(cd.host);
            this.dbPortTextField.setText(cd.port);
            this.dbNameTextField.setText(cd.database);
            this.previousDbHost = cd.host;
            this.previousDbPort = cd.port;
            this.previousDbName = cd.database;
            if (cd.type == null || cd.type.trim().length() == 0 || cd.type.equalsIgnoreCase(PreferencesDialog.getUnspecifiedDatabaseTypeName())) {
                this.dbTypeList.setSelectedItem(PreferencesDialog.getUnspecifiedDatabaseTypeName());
            } else {
                this.dbTypeList.setSelectedItem(cd.type);
            }
            this.setJdbcConnectionUrl(cd.jdbcUrl);
            this.setJdbcUsername(cd.userName);
            this.setJdbcPassword(cd.password);
            this.setDatabaseSchema(cd.schemas);
            this.setRequireSchema(cd.requireSchemas);
        } else {
            this.setDefault("false");
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        String conName = (String)this.conNameList.getSelectedItem();
        if (conName == null || conName.trim().equals("")) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("preferences.noconnectionname.alert", "Connection name must be set."), "", 2);
            return;
        }
        this.accepted = true;
        if (this.getJdbcConnectionUrl() == null || this.getJdbcConnectionUrl().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("preferences.no.url.alert", "Jdbc connection URL must be set."), "", 2);
            return;
        }
        conName = PreferencesDialog.getConnectionNameFromListName(conName);
        if (this.getDefault()) {
            for (Workbench.ConnectionDetails aDetails : this.getConnectionDetailsMap().values()) {
                aDetails.put("Default", "false");
            }
        }
        Workbench.ConnectionDetails cDetails = this.workbench.newConnectionDetails();
        cDetails.put("ConnectionName", conName);
        cDetails.put("DriverClassName", this.getJdbcDriverClassName());
        cDetails.put("Type", (String)this.dbTypeList.getSelectedItem());
        cDetails.put("Host", this.dbHostTextField.getText());
        cDetails.put("Port", this.dbPortTextField.getText());
        cDetails.put("Database", this.dbNameTextField.getText());
        cDetails.put("JdbcUrl", this.getJdbcConnectionUrl());
        cDetails.put("Username", this.getJdbcUsername());
        cDetails.put("Password", this.getJdbcPassword());
        cDetails.put("Schemas", this.getDatabaseSchema());
        cDetails.put("RequireSchemas", Boolean.toString(this.getRequireSchema()));
        cDetails.put("Default", Boolean.toString(this.getDefault()));
        this.getConnectionDetailsMap().put(conName, cDetails);
        String selectName = null;
        selectName = this.getDefault() ? conName + PreferencesDialog.getDefaultConnectionNameIndicator() : conName;
        PreferencesDialog.regenerateConnectionNames(this.getConnectionDetailsMap(), this.conNameList, selectName, -1);
        this.workbench.storeWorkbenchProperties();
        this.updateDatabasePanel(selectName);
        JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("preferences.connectionSaved.alert", "Connection information has been saved."), "", 1);
    }

    public static String regenerateConnectionNames(Map<String, Workbench.ConnectionDetails> conNameDetails, JComboBox conNameList, String selectedItem, int selectedIndex) {
        String selItem = selectedItem;
        Vector<String> v = new Vector<String>();
        for (String cname : conNameDetails.keySet()) {
            Workbench.ConnectionDetails cdetails = conNameDetails.get(cname);
            if (cdetails.defaultConnection) {
                if (selectedItem != null && selectedItem.equals(cname)) {
                    selItem = cname + PreferencesDialog.getDefaultConnectionNameIndicator();
                }
                cname = cname + PreferencesDialog.getDefaultConnectionNameIndicator();
            }
            v.add(cname);
        }
        DefaultComboBoxModel cbm = new DefaultComboBoxModel(v);
        conNameList.setModel(cbm);
        if (selectedItem != null) {
            conNameList.setSelectedItem(selItem);
            return selItem;
        }
        if (conNameList.getItemCount() > 0) {
            conNameList.setSelectedIndex(selectedIndex);
            return (String)conNameList.getSelectedItem();
        }
        conNameList.setSelectedIndex(-1);
        return null;
    }

    private void urlTextFieldFocusLost() {
        if (!this.urlTextField.getText().equals(this.previousUrl)) {
            this.resetDatabaseConnectionParameters();
            JdbcConnectionConfiguration dbt = this.getCurrentDbType();
            if (dbt != null && !dbt.isFreeform()) {
                dbt.parse(this.urlTextField.getText());
            }
            this.previousUrl = this.urlTextField.getText();
        }
    }

    private void dbHostTextFieldFocusLost() {
        if (!this.dbHostTextField.getText().equals(this.previousDbHost)) {
            this.setJdbcConnectionUrl();
            this.previousDbHost = this.dbHostTextField.getText();
        }
    }

    private void dbPortTextFieldFocusLost() {
        if (!this.dbPortTextField.getText().equals(this.previousDbPort)) {
            this.setJdbcConnectionUrl();
            this.previousDbPort = this.dbPortTextField.getText();
        }
    }

    private void dbNameTextFieldFocusLost() {
        if (!this.dbNameTextField.getText().equals(this.previousDbName)) {
            this.setJdbcConnectionUrl();
            this.previousDbName = this.dbNameTextField.getText();
        }
    }

    private void resetDatabaseConnectionParameters() {
        this.dbHostTextField.setText("");
        this.dbPortTextField.setText("");
        this.dbNameTextField.setText("");
        this.previousDbHost = "";
        this.previousDbPort = "";
        this.previousDbName = "";
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.conNameList.setSelectedIndex(-1);
        this.setDefault("false");
        this.dbTypeList.setSelectedIndex(-1);
        this.resetJdbcDriverClassName();
        this.resetDatabaseConnectionParameters();
        this.resetJdbcConnectionUrl();
        this.setJdbcUsername("");
        this.setJdbcPassword("");
        this.resetDatabaseSchema();
        this.setRequireSchema(false);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        String conName = PreferencesDialog.getConnectionNameFromListName((String)this.conNameList.getSelectedItem());
        if (this.workbench.isConNameUsedBySchema(conName)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("preferences.deleteConnection.alert", "Could not delete database connection \"{0}\".\nAn opened schema file is using this connection", conName), "", 2);
            return;
        }
        this.getConnectionDetailsMap().remove(conName);
        PreferencesDialog.regenerateConnectionNames(this.getConnectionDetailsMap(), this.conNameList, null, 0);
        this.workbench.storeWorkbenchProperties();
        this.cancelButtonActionPerformed(evt);
    }

    public Map<String, Workbench.ConnectionDetails> getConnectionDetailsMap() {
        return this.connectionDetailsMap;
    }

    public void updateConNameList(Map<String, Workbench.ConnectionDetails> conNameDetails, String selectName) {
        this.connectionDetailsMap = conNameDetails;
        selectName = PreferencesDialog.regenerateConnectionNames(this.connectionDetailsMap, this.conNameList, selectName, 0);
        this.updateDatabasePanel(PreferencesDialog.getConnectionNameFromListName(selectName));
    }

    public String getConnectionName() {
        return (String)this.conNameList.getSelectedItem();
    }

    private void setDbTypeList() {
        this.dbTypeMap = new TreeMap();
        this.dbTypeMap.put("IBM DB2", new JdbcConnectionConfiguration("IBM DB2", "com.ibm.db2.jcc.DB2Driver", "jdbc:db2://%s%s/%s", ":", "jdbc:db2://(\\S*?)(:\\d*)?/(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        this.dbTypeMap.put("PostgreSQL", new JdbcConnectionConfiguration("PostgreSQL", "org.postgresql.Driver", "jdbc:postgresql://%s%s/%s", ":", "jdbc:postgresql://(\\S*?)(:\\d*)?/(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        this.dbTypeMap.put("Greenplum", new JdbcConnectionConfiguration("Greenplum", "org.postgresql.Driver", "jdbc:postgresql://%s%s/%s", ":", "jdbc:postgresql://(\\S*?)(:\\d*)?/(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        this.dbTypeMap.put("MySQL", new JdbcConnectionConfiguration("MySQL", "com.mysql.jdbc.Driver", "jdbc:mysql://%s%s/%s", ":", "jdbc:mysql://(\\S*?)(:\\d*)?/(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        this.dbTypeMap.put("JDBC-ODBC", new JdbcConnectionConfiguration("JDBC-ODBC", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:%s", null, "jdbc:odbc:(\\S*?)", new JTextField[]{this.dbNameTextField}));
        this.dbTypeMap.put("Derby (Embedded)", new JdbcConnectionConfiguration("Derby (Embedded)", "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:%s", null, "jdbc:derby:(\\S*?)", new JTextField[]{this.dbNameTextField}));
        this.dbTypeMap.put("InfoBright", new JdbcConnectionConfiguration("InfoBright", "com.mysql.jdbc.Driver", "jdbc:mysql://%s%s/%s", ":", "jdbc:mysql://(\\S*?)(:\\d*)?/(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        this.dbTypeMap.put("Firebird", new JdbcConnectionConfiguration("Firebird", "org.firebirdsql.jdbc.FBDriver", "jdbc:firebirdsql:%s%s:%s", "/", "jdbc:firebirdsql:(\\S*?)(/\\d*)?:(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        this.dbTypeMap.put("Oracle", new JdbcConnectionConfiguration("Oracle", "oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@%s%s:%s", ":", "jdbc:oracle:thin:@(\\S*?)(:\\d*)?:(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        this.dbTypeMap.put("Hypersonic", new JdbcConnectionConfiguration("Hypersonic", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:%s", null, "jdbc:hsqldb:(\\S*?)", new JTextField[]{this.dbNameTextField}));
        this.dbTypeMap.put("Ingres", new JdbcConnectionConfiguration("Ingres", "com.ingres.jdbc.IngresDriver", "jdbc:ingres://@%s%s/%s", ":", "jdbc:ingres://(\\S*?)(:\\d*)?/(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        this.dbTypeMap.put("Netezza", new JdbcConnectionConfiguration("Netezza", "org.netezza.Driver", "jdbc:netezza://%s%s/%s", ":", "jdbc:neteeza://(\\S*?)(:\\d*)?/(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        this.dbTypeMap.put("Sybase (jTDS Driver)", new JdbcConnectionConfiguration("Sybase (jTDS Driver)", "net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:sybase://%s%s/%s", ":", "jdbc:jtds:sybase://(\\S*?)(:\\d*)?/(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        this.dbTypeMap.put("Microsoft SQL Server", new JdbcConnectionConfiguration("Microsoft SQL Server", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://%s%s;databaseName=%s;SelectMethod=cursor", ":", "jdbc:sqlserver://(\\S*?)(:\\d*)?/(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        this.dbTypeMap.put("Teradata", new JdbcConnectionConfiguration("Teradata", "com.ncr.teradata.TeraDriver", "jdbc:teradata://%s%s/DATABASE=%s", ":", "jdbc:teradata://(\\S*?)(:\\d*)?/DATABASE=(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        this.dbTypeMap.put("LucidDB", new JdbcConnectionConfiguration("LucidDB", "com.lucidera.jdbc.LucidDbRmiDriver", "jdbc:luciddb:rmi://%s%s;schema=%s", ":", "jdbc:luciddb:rmi://(\\S*?)(:\\d*)?;schema=(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        this.dbTypeMap.put("HP NeoView", new JdbcConnectionConfiguration("HP NeoView", "com.hp.t4jdbc.HPT4Driver", "jdbc:hpt4jdbc://%s%s:/schema=%s;serverDataSource=%s", ":", "jdbc:hpt4jdbc://(\\S*?)(:\\d*)?:/schema=(\\S*?)(\\?.*)?;serverDataSource=(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField, this.dbNameTextField}));
        this.dbTypeMap.put("Vertica", new JdbcConnectionConfiguration("Vertica", "com.vertica.Driver", "jdbc:vertica://%s%s/%s", ":", "jdbc:vertica://(\\S*?)(:\\d*)?/(\\S*?)(\\?.*)?", new JTextField[]{this.dbHostTextField, this.dbPortTextField, this.dbNameTextField}));
        LinkedHashSet comboList = new LinkedHashSet(this.dbTypeMap.keySet());
        this.dbTypeMap.put(PreferencesDialog.getUnspecifiedDatabaseTypeName(), new JdbcConnectionConfiguration(PreferencesDialog.getUnspecifiedDatabaseTypeName()));
        comboList.add(PreferencesDialog.getUnspecifiedDatabaseTypeName());
        DefaultComboBoxModel<Object> cbm = new DefaultComboBoxModel<Object>(comboList.toArray());
        this.dbTypeList.setModel(cbm);
        this.dbTypeList.setSelectedIndex(-1);
    }

    class JdbcConnectionConfiguration {
        private String typeName = null;
        private String driver = null;
        private String urlFormat = null;
        private String portSeparator = null;
        private JTextField[] objArgs = null;
        private boolean freeform = true;
        private Pattern pattern = null;

        public JdbcConnectionConfiguration(String typeName) {
            this.typeName = typeName;
        }

        public JdbcConnectionConfiguration(String typeName, String driver, String urlFormat, String portSeparator, String parseFormat, JTextField[] objArgs) {
            this(typeName);
            this.driver = driver;
            this.urlFormat = urlFormat;
            this.portSeparator = portSeparator;
            this.objArgs = objArgs;
            this.freeform = false;
            this.pattern = Pattern.compile(parseFormat);
        }

        public String getUrl() {
            ArrayList<String> args = new ArrayList<String>(this.objArgs.length);
            for (JTextField field : this.objArgs) {
                args.add(field.getText());
            }
            if (args.size() > 1 && ((String)args.get(1)).trim().length() > 0 && this.portSeparator != null) {
                args.set(1, this.portSeparator + (String)args.get(1));
            } else {
                args.set(1, "");
            }
            return String.format(this.urlFormat, args.toArray());
        }

        public void parse(String urlString) {
            if (this.isFreeform() || this.objArgs == null || this.objArgs.length == 0) {
                return;
            }
            Matcher matcher = this.pattern.matcher(urlString);
            if (!matcher.matches()) {
                return;
            }
            if (matcher.groupCount() != 1 && matcher.groupCount() != 4) {
                return;
            }
            this.objArgs[0].setText(matcher.group(1).trim());
            if (matcher.groupCount() == 4) {
                this.objArgs[1].setText(matcher.group(2) == null || matcher.group(2).trim().length() == 1 ? "" : matcher.group(2).trim().substring(1));
                this.objArgs[2].setText(matcher.group(3) == null ? "" : matcher.group(3).trim());
            } else {
                this.objArgs[1].setText("");
                this.objArgs[2].setText("");
            }
            PreferencesDialog.this.previousDbHost = PreferencesDialog.this.dbHostTextField.getText();
            PreferencesDialog.this.previousDbPort = PreferencesDialog.this.dbPortTextField.getText();
            PreferencesDialog.this.previousDbName = PreferencesDialog.this.dbNameTextField.getText();
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getDriver() {
            return this.driver;
        }

        public boolean isFreeform() {
            return this.freeform;
        }
    }
}

