/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ParentInPath {
    public Object parent;
    public int pathIndex;

    ParentInPath(Object parent, int pathIndex) {
        this.parent = parent;
        this.pathIndex = pathIndex;
    }

    public static ParentInPath getParentOfSelection(JTree currentTree, Class ... parentClassz) {
        return ParentInPath.getParentInPath(currentTree.getSelectionPath(), parentClassz);
    }

    public static ParentInPath getParentInPath(TreePath tpath, Class ... parentClassz) {
        if (parentClassz.length == 0) {
            throw new IllegalArgumentException("no classes passed");
        }
        if (tpath == null) {
            throw new IllegalArgumentException("null path");
        }
        Class[] parentClasses = parentClassz;
        for (int parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
            Object p = tpath.getPathComponent(parentIndex);
            if (p.getClass() != parentClasses[0]) continue;
            boolean failed = false;
            if (parentClasses.length > 1) {
                for (int i = 1; i < parentClasses.length && parentIndex - i >= 0 && !failed; ++i) {
                    failed = tpath.getPathComponent(parentIndex - i).getClass() != parentClasses[i];
                }
            }
            if (failed) continue;
            return new ParentInPath(p, parentIndex);
        }
        return new ParentInPath(null, -1);
    }

    boolean isEmpty() {
        return this.parent == null;
    }
}

