/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class JTreeUpdater
implements TreeExpansionListener,
TreeSelectionListener {
    private JTree tree = null;
    private Set<TreePath> expandedTreePaths = new HashSet<TreePath>();
    private TreePath[] selectedTreePaths = new TreePath[0];

    public JTreeUpdater(JTree tree) {
        this.tree = tree;
        this.tree.addTreeExpansionListener(this);
        this.tree.addTreeSelectionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update() {
        JTree jTree = this.tree;
        synchronized (jTree) {
            this.tree.removeTreeExpansionListener(this);
            this.tree.removeTreeSelectionListener(this);
            ((DefaultTreeModel)this.tree.getModel()).reload();
            for (TreePath treePath : this.expandedTreePaths) {
                this.tree.expandPath(treePath);
            }
            this.tree.getSelectionModel().setSelectionPaths(this.selectedTreePaths);
            this.tree.addTreeExpansionListener(this);
            this.tree.addTreeSelectionListener(this);
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath expandedPath = treeExpansionEvent.getPath();
        Object[] paths = this.expandedTreePaths.toArray();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = (TreePath)paths[i];
            if (!path.isDescendant(expandedPath)) continue;
            this.expandedTreePaths.remove(path);
        }
        this.expandedTreePaths.add(expandedPath);
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreePath collapsedPath = treeExpansionEvent.getPath();
        this.expandedTreePaths.remove(collapsedPath);
        Object[] paths = this.expandedTreePaths.toArray();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = (TreePath)paths[i];
            if (!collapsedPath.isDescendant(path)) continue;
            this.expandedTreePaths.remove(path);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.tree.getSelectionPaths() != null && this.tree.getSelectionPaths().length > 0) {
            this.selectedTreePaths = this.tree.getSelectionModel().getSelectionPaths();
        }
    }
}

