/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import mondrian.gui.LanguageChangedEvent;
import mondrian.gui.LanguageChangedListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18n {
    private static final Logger LOGGER = Logger.getLogger(I18n.class);
    private Locale currentLocale = Locale.ENGLISH;
    private ResourceBundle guiBundle = null;
    private List<ResourceBundle> additionalGuiBundles = new ArrayList<ResourceBundle>();
    private ResourceBundle languageBundle = null;
    private List<ResourceBundle> additionalLanguageBundles = new ArrayList<ResourceBundle>();
    private final ClassLoader myClassLoader = this.getClass().getClassLoader();
    private static String defaultIcon = "nopic";
    private static List<LanguageChangedListener> languageChangedListeners = new ArrayList<LanguageChangedListener>();

    public static void addOnLanguageChangedListener(LanguageChangedListener listener) {
        languageChangedListeners.add(listener);
    }

    public I18n(ResourceBundle guiBundle, ResourceBundle languageBundle) {
        this.guiBundle = guiBundle;
        this.languageBundle = languageBundle;
    }

    public I18n(ResourceBundle guiBundle, List<ResourceBundle> additionalGuiBundles, ResourceBundle languageBundle, List<ResourceBundle> additionalLanguageBundles) {
        this(guiBundle, languageBundle);
        this.additionalGuiBundles = additionalGuiBundles;
        this.additionalLanguageBundles = additionalLanguageBundles;
    }

    public static List<Locale> getListOfAvailableLanguages(Class cl) {
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        try {
            Set<String> names = I18n.getResourcesInPackage(cl, cl.getName());
            for (String name : names) {
                StringTokenizer tokenizer;
                String lang = name.substring(name.lastIndexOf(47) + 1);
                if (lang.indexOf(".properties") < 0 || (tokenizer = new StringTokenizer(lang = lang.substring(0, lang.indexOf(".properties")), "_")).countTokens() <= 1) continue;
                String language = "";
                String country = "";
                String variant = "";
                int i = 0;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    switch (i) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            language = token;
                            break;
                        }
                        case 2: {
                            country = token;
                            break;
                        }
                        case 3: {
                            variant = token;
                            break;
                        }
                    }
                    ++i;
                }
                Locale model = new Locale(language, country, variant);
                supportedLocales.add(model);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"getListOfAvailableLanguages", (Throwable)e);
        }
        Collections.sort(supportedLocales, new Comparator<Object>(){

            @Override
            public int compare(Object lhs, Object rhs) {
                String ls = ((Locale)lhs).getDisplayLanguage();
                String rs = ((Locale)rhs).getDisplayLanguage();
                if (ls.equals("pap")) {
                    ls = "Papiamentu";
                }
                if (rs.equals("pap")) {
                    rs = "Papiamentu";
                }
                return ls.compareTo(rs);
            }
        });
        return supportedLocales;
    }

    public static Set<String> getResourcesInPackage(Class coreClass, String packageName) throws IOException {
        String localPackageName = packageName.endsWith("/") ? packageName : packageName + '/';
        ClassLoader cl = coreClass.getClassLoader();
        Enumeration<URL> dirEnum = cl.getResources(localPackageName);
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        while (dirEnum.hasMoreElements()) {
            URL resUrl = dirEnum.nextElement();
            if (resUrl.getProtocol().equals("file")) {
                try {
                    File dir = new File(resUrl.getFile());
                    File[] files = dir.listFiles();
                    if (files == null) continue;
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file.isDirectory()) continue;
                        names.add(localPackageName + file.getName());
                    }
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
            }
            if (!resUrl.getProtocol().equals("jar")) continue;
            JarURLConnection jconn = (JarURLConnection)resUrl.openConnection();
            JarFile jfile = jconn.getJarFile();
            Enumeration<JarEntry> entryEnum = jfile.entries();
            while (entryEnum.hasMoreElements()) {
                String parentDirName;
                JarEntry entry = entryEnum.nextElement();
                String entryName = entry.getName();
                if (entryName.equals(localPackageName) || !(parentDirName = entryName.substring(0, entryName.lastIndexOf(47) + 1)).equals(localPackageName)) continue;
                names.add(entryName);
            }
        }
        return names;
    }

    public void setCurrentLocale(String language) {
        this.setCurrentLocale(language, null);
    }

    public void setCurrentLocale(String language, String country) {
        if (language != null && !language.equals("")) {
            if (country != null && !country.equals("")) {
                this.setCurrentLocale(new Locale(language, country));
            } else {
                this.setCurrentLocale(new Locale(language));
            }
        } else {
            this.setCurrentLocale(Locale.getDefault());
        }
    }

    public void setCurrentLocale(Locale locale) {
        this.currentLocale = locale;
        this.languageBundle = null;
        for (LanguageChangedListener listener : languageChangedListeners) {
            try {
                listener.languageChanged(new LanguageChangedEvent(locale));
            }
            catch (Exception ex) {
                LOGGER.error((Object)"setCurrentLocale", (Throwable)ex);
            }
        }
    }

    public Locale getCurrentLocale() {
        if (this.currentLocale == null) {
            this.currentLocale = Locale.getDefault();
        }
        return this.currentLocale;
    }

    public String getGUIReference(String reference) {
        return this.getGUIReference(reference, false);
    }

    public String getGUIReference(String reference, boolean optional) {
        for (ResourceBundle bundle : this.additionalGuiBundles) {
            try {
                return bundle.getString(reference);
            }
            catch (MissingResourceException ex) {
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Exception loading reference = " + reference + " for bundle = " + bundle.toString()), (Throwable)ex);
                return this.guiBundle.getString(defaultIcon);
            }
        }
        try {
            if (this.guiBundle == null) {
                throw new Exception("No GUI bundle");
            }
            return this.guiBundle.getString(reference);
        }
        catch (MissingResourceException ex) {
            if (!optional) {
                LOGGER.error((Object)("Can't find the translation for key = " + reference));
                throw ex;
            }
            return null;
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception loading reference = " + reference), (Throwable)ex);
            return this.guiBundle.getString(defaultIcon);
        }
    }

    public String getString(String stringId) {
        return this.getString(stringId, this.getCurrentLocale());
    }

    public String getString(String stringId, String defaultValue) {
        return this.getString(stringId, this.getCurrentLocale(), defaultValue);
    }

    public String getFormattedString(String stringId, String defaultValue, Object ... args) {
        String pattern = this.getString(stringId, this.getCurrentLocale(), defaultValue);
        MessageFormat mf = new MessageFormat(pattern, this.getCurrentLocale());
        return mf.format(args);
    }

    private String getString(String stringId, Locale currentLocale) {
        return this.getString(stringId, currentLocale, stringId);
    }

    public String getString(String stringId, Locale currentLocale, String defaultValue) {
        for (ResourceBundle bundle : this.additionalLanguageBundles) {
            try {
                return bundle.getString(stringId);
            }
            catch (MissingResourceException ex) {
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Exception loading stringID = " + stringId + " for bundle = " + bundle.toString()), (Throwable)ex);
                return defaultValue;
            }
        }
        try {
            if (this.languageBundle == null) {
                throw new Exception("No language bundle");
            }
            return this.languageBundle.getString(stringId);
        }
        catch (MissingResourceException ex) {
            LOGGER.error((Object)("Can't find the translation for key = " + stringId + ": using default (" + defaultValue + ")"));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception loading stringID = " + stringId), (Throwable)ex);
        }
        return defaultValue;
    }

    public static String getCurrentLocaleID() {
        return "";
    }

    public List<ResourceBundle> getAdditionalGuiBundles() {
        return this.additionalGuiBundles;
    }

    public void setAdditionalGuiBundles(List<ResourceBundle> additionalGuiBundles) {
        this.additionalGuiBundles = additionalGuiBundles;
    }

    public List<ResourceBundle> getAdditionalLanguageBundles() {
        return this.additionalLanguageBundles;
    }

    public void setAdditionalLanguageBundles(List<ResourceBundle> additionalLanguageBundles) {
        this.additionalLanguageBundles = additionalLanguageBundles;
    }

    public void addLanguageResourceBundle(String bundleName) {
        this.addResourceBundleByName(bundleName, this.getAdditionalLanguageBundles());
    }

    public void addGuiResourceBundle(String bundleName) {
        this.addResourceBundleByName(bundleName, this.getAdditionalGuiBundles());
    }

    private void addResourceBundleByName(String bundleName, List<ResourceBundle> currentBundleList) {
        ResourceBundle newBundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), this.myClassLoader);
        if (currentBundleList != null) {
            currentBundleList.add(newBundle);
        }
    }
}

