/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.support;

import java.util.Map;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.binding.expression.EvaluationAttempt;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.PropertyExpression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class BeanWrapperExpression
implements PropertyExpression {
    private String expression;

    public BeanWrapperExpression(String expression) {
        this.expression = expression;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BeanWrapperExpression)) {
            return false;
        }
        BeanWrapperExpression other = (BeanWrapperExpression)o;
        return this.expression.equals(other.expression);
    }

    public Object evaluateAgainst(Object target, Map evaluationContext) throws EvaluationException {
        try {
            return new BeanWrapperImpl(target).getPropertyValue(this.expression);
        }
        catch (BeansException e) {
            throw new EvaluationException(new EvaluationAttempt(this, target, evaluationContext), e);
        }
    }

    public void setValue(Object target, Object value, Map setContext) throws EvaluationException {
        try {
            Assert.notNull((Object)target, (String)"The target object to evaluate is required");
            new BeanWrapperImpl(target).setPropertyValue(this.expression, value);
        }
        catch (BeansException e) {
            throw new EvaluationException(new EvaluationAttempt(this, target, setContext), e);
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("expression", (Object)this.expression).toString();
    }
}

