/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.wrappers.XercesDOMParser;

public class ParserTester {
    private int parserType;
    private static final int MSXML = 1;
    private static final int XERCES = 2;
    private Parser parser;
    String modelDocType;
    String dtdUrl;

    public ParserTester(String string, int n) throws XOMException, IOException {
        this.parserType = n;
        this.parser = null;
        File file = new File(string);
        this.modelDocType = string.substring(0, string.indexOf("."));
        this.dtdUrl = "file:" + file.getAbsolutePath();
        switch (n) {
            case 2: {
                this.parser = new XercesDOMParser(true);
                break;
            }
            default: {
                throw new XOMException("Unknown parser type: " + n);
            }
        }
    }

    public void testFile(String string) throws XOMException {
        String string2 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            FileReader fileReader = new FileReader(string);
            if (this.parserType != 1) {
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.println("<?xml version=\"1.0\" ?>");
                if (this.modelDocType != null) {
                    printWriter.println("<!DOCTYPE " + this.modelDocType + " SYSTEM \"" + this.dtdUrl + "\">");
                }
                printWriter.flush();
            }
            ParserTester.readerToWriter(fileReader, stringWriter);
            fileReader.close();
            string2 = stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new XOMException("Unable to read input test " + string + ": " + iOException.getMessage());
        }
        this.parser.parse(string2);
        System.out.println("Parsing document succeeded.");
    }

    private static void readerToWriter(Reader reader, Writer writer) throws IOException {
        int n;
        char[] cArray = new char[16384];
        while ((n = reader.read(cArray)) != -1) {
            if (n <= 0) continue;
            writer.write(cArray, 0, n);
        }
    }

    public static void main(String[] stringArray) throws XOMException, IOException {
        int n = 0;
        if (stringArray.length > 0 && stringArray[0].equals("-debug")) {
            System.err.println("parserTest pausing for debugging. Attach your debugger and press return.");
            try {
                System.in.read();
                ++n;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int n2 = 1;
        if (n < stringArray.length && stringArray[n].equals("-msxml")) {
            n2 = 1;
            ++n;
        } else if (n < stringArray.length && stringArray[n].equals("-xerces")) {
            n2 = 2;
            ++n;
        }
        if (stringArray.length < n + 2) {
            System.err.println("Usage: java ParserTester [-debug] [-msxml | -xerces] <DTD file> <XML file>");
            System.exit(-1);
        }
        ParserTester parserTester = new ParserTester(stringArray[n], n2);
        parserTester.testFile(stringArray[++n]);
    }
}

