/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.messaging.saaj.soap.Envelope;
import com.sun.xml.messaging.saaj.soap.EnvelopeFactory;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.messaging.saaj.util.JAXMStreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.MimeBodyPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class SOAPPartImpl
extends SOAPPart {
    static EnvelopeFactory envFactory = null;
    MimeHeaders headers = new MimeHeaders();
    Envelope envelope;
    Source source;

    public SOAPPartImpl() {
        this.headers.setHeader("Content-Type", "text/xml");
        if (envFactory == null) {
            envFactory = EnvelopeFactory.getInstance();
        }
    }

    public SOAPEnvelope getEnvelope() throws SOAPException {
        if (this.envelope != null) {
            if (this.source == null) {
                return this.envelope;
            }
            this.envelope = envFactory.createEnvelope(this.source);
            this.source = null;
            return this.envelope;
        }
        if (this.source != null) {
            this.envelope = envFactory.createEnvelope(this.source);
            this.source = null;
            return this.envelope;
        }
        this.envelope = envFactory.createEnvelope();
        return this.envelope;
    }

    public void removeAllMimeHeaders() {
        this.headers.removeAllHeaders();
    }

    public void removeMimeHeader(String header) {
        this.headers.removeHeader(header);
    }

    public String[] getMimeHeader(String name) {
        return this.headers.getHeader(name);
    }

    public void setMimeHeader(String name, String value) {
        this.headers.setHeader(name, value);
    }

    public void addMimeHeader(String name, String value) {
        this.headers.addHeader(name, value);
    }

    public Iterator getAllMimeHeaders() {
        return this.headers.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        return this.headers.getMatchingHeaders(names);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this.headers.getNonMatchingHeaders(names);
    }

    public Source getContent() throws SOAPException {
        if (this.source != null) {
            return this.source;
        }
        return ((Envelope)this.getEnvelope()).getContent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContent(Source source) throws SOAPException {
        try {
            if (source instanceof StreamSource) {
                InputStream is = ((StreamSource)source).getInputStream();
                Reader rdr = ((StreamSource)source).getReader();
                if (is != null) {
                    this.source = new JAXMStreamSource(is);
                    return;
                } else {
                    if (rdr == null) throw new SOAPException("Source does not have a valid Reader or InputStream");
                    this.source = new JAXMStreamSource(rdr);
                }
                return;
            } else {
                this.source = source;
            }
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SOAPException("Error setting the source for SOAPPart: " + ex.getMessage());
        }
    }

    public ByteInputStream getContentAsStream() throws IOException {
        InputStream is;
        if (this.source != null && this.source instanceof StreamSource && (is = ((StreamSource)this.source).getInputStream()) != null) {
            if (!(is instanceof ByteInputStream)) {
                throw new IOException("Internal error: stream not of the right type");
            }
            return (ByteInputStream)is;
        }
        ByteOutputStream b = new ByteOutputStream();
        Envelope env = null;
        try {
            env = (Envelope)this.getEnvelope();
            env.output(b);
        }
        catch (SOAPException sex) {
            throw new IOException("SOAP exception while trying to externalize: " + sex.getMessage());
        }
        return new ByteInputStream(b.getBytes(), b.getCount());
    }

    /*
     * WARNING - void declaration
     */
    MimeBodyPart getMimePart() throws SOAPException {
        try {
            void ex;
            MimeBodyPart headerEnvelope = new MimeBodyPart();
            headerEnvelope.setDataHandler(this.getDataHandler());
            AttachmentPartImpl.copyMimeHeaders(this.headers, headerEnvelope);
            return ex;
        }
        catch (SOAPException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SOAPException("Unable to externalize header", (Throwable)ex);
        }
    }

    MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    DataHandler getDataHandler() {
        DataSource ds = new DataSource(){

            public OutputStream getOutputStream() throws IOException {
                throw new IOException("Illegal Operation");
            }

            public String getContentType() {
                return "text/xml";
            }

            public String getName() {
                return SOAPPartImpl.this.getContentId();
            }

            public InputStream getInputStream() throws IOException {
                return SOAPPartImpl.this.getContentAsStream();
            }
        };
        return new DataHandler(ds);
    }
}

