/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.client.p2p.http.handler;

import com.sun.xml.messaging.saaj.client.p2p.http.handler.AuthenticationInfo;
import com.sun.xml.messaging.saaj.client.p2p.http.handler.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import sun.net.www.HeaderParser;

class DigestAuthentication
extends AuthenticationInfo {
    private PasswordAuthentication pw;
    private URL url;
    private String authMethod;
    private static final char[] charArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestAuthentication(URL url, String realm, String authMethod, PasswordAuthentication pw) {
        super('s', url.getHost(), url.getPort(), realm);
        this.authMethod = authMethod;
        this.url = url;
        this.pw = pw;
    }

    boolean supportsPreemptiveAuthorization() {
        return false;
    }

    String getHeaderName() {
        return "";
    }

    String getHeaderValue() {
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean setHeaders(HttpURLConnection conn, HeaderParser p) {
        String response;
        String uri;
        String nonce;
        block9: {
            String algorithm;
            nonce = p.findValue("nonce");
            uri = this.url.getFile();
            if (nonce == null || this.authMethod == null || this.pw == null || this.realm == null) {
                return false;
            }
            if (this.authMethod.length() >= 1) {
                this.authMethod = Character.toUpperCase(this.authMethod.charAt(0)) + this.authMethod.substring(1).toLowerCase();
            }
            if ((algorithm = p.findValue("algorithm")) == null || "".equals(algorithm)) {
                algorithm = "MD5";
            }
            char[] passwd = this.pw.getPassword();
            try {
                try {
                    response = this.computeDigest(this.pw.getUserName(), passwd, this.realm, conn.getMethod(), uri, nonce, algorithm);
                    if (passwd != null) {
                        Arrays.fill(passwd, ' ');
                    }
                    passwd = null;
                }
                catch (NoSuchAlgorithmException ex) {
                    boolean bl = false;
                    Object var11_9 = null;
                    if (passwd == null) return bl;
                    Arrays.fill(passwd, ' ');
                    return bl;
                }
                Object var11_8 = null;
                if (passwd == null) break block9;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                if (passwd != null) {
                    Arrays.fill(passwd, ' ');
                }
                throw throwable;
            }
            Arrays.fill(passwd, ' ');
        }
        String value = this.authMethod + " username=\"" + this.pw.getUserName() + "\", realm=\"" + this.realm + "\", nonce=\"" + nonce + "\", uri=\"" + uri + "\", response=\"" + response + "\"";
        conn.setAuthenticationProperty("Authorization", value);
        return true;
    }

    private String computeDigest(String userName, char[] password, String realm, String connMethod, String requestURI, String nonceString, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        String A1 = userName + ":" + realm + ":";
        String HashA1 = this.encode(A1, password, md);
        String A2 = connMethod + ":" + requestURI;
        String HashA2 = this.encode(A2, null, md);
        String combo = HashA1 + ":" + nonceString + ":" + HashA2;
        String finalHash = this.encode(combo, null, md);
        return finalHash;
    }

    private String encode(String src, char[] passwd, MessageDigest md) {
        md.update(src.getBytes());
        if (passwd != null) {
            byte[] passwdBytes = new byte[passwd.length];
            int i = 0;
            while (i < passwd.length) {
                passwdBytes[i] = (byte)passwd[i];
                ++i;
            }
            md.update(passwdBytes);
            Arrays.fill(passwdBytes, (byte)0);
        }
        byte[] digest = md.digest();
        StringBuffer res = new StringBuffer(digest.length * 2);
        int i = 0;
        while (i < digest.length) {
            int hashchar = digest[i] >>> 4 & 0xF;
            res.append(charArray[hashchar]);
            hashchar = digest[i] & 0xF;
            res.append(charArray[hashchar]);
            ++i;
        }
        return res.toString();
    }
}

