/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleRow;

public class OracleCachedRowSetWriter
implements RowSetWriter,
Serializable {
    static final long serialVersionUID = 8932894189919931169L;
    private StringBuffer updateClause = new StringBuffer("");
    private StringBuffer deleteClause = new StringBuffer("");
    private StringBuffer insertClause = new StringBuffer("");
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private ResultSetMetaData rsmd;
    private transient Connection connection;
    private int columnCount;
    static final int ASCII_STREAM = 1;
    static final int BINARY_STREAM = 2;
    static final int CHARACTER_STREAM = 3;
    static final int NCHARACTER_STREAM = 4;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:28:36_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    private String getSchemaName(RowSet rowSet) throws SQLException {
        return rowSet.getUsername();
    }

    private String getTableName(RowSet rowSet) throws SQLException {
        String string = ((OracleCachedRowSet)rowSet).getTableName();
        if (string != null) {
            return string;
        }
        String string2 = rowSet.getCommand().toUpperCase();
        int n2 = string2.indexOf(" FROM ");
        if (n2 == -1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 343, string2.length() != 0 ? string2 : "Please use RowSet.setCommand (String) to set the SQL query string.");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string3 = string2.substring(n2 + 6).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        return string3;
    }

    private void initSQLStatement(RowSet rowSet) throws SQLException {
        int n2;
        this.insertClause = new StringBuffer("INSERT INTO " + this.getTableName(rowSet) + "(");
        this.updateClause = new StringBuffer("UPDATE " + this.getTableName(rowSet) + " SET ");
        this.deleteClause = new StringBuffer("DELETE FROM " + this.getTableName(rowSet) + " WHERE ");
        this.rsmd = rowSet.getMetaData();
        this.columnCount = this.rsmd.getColumnCount();
        for (n2 = 0; n2 < this.columnCount; ++n2) {
            if (n2 != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append(this.rsmd.getColumnName(n2 + 1));
            if (n2 != 0) {
                this.updateClause.append(", ");
            }
            this.updateClause.append(this.rsmd.getColumnName(n2 + 1) + " = :" + n2);
            if (n2 != 0) {
                this.deleteClause.append(" AND ");
            }
            this.deleteClause.append(this.rsmd.getColumnName(n2 + 1) + " = :" + n2);
        }
        this.insertClause.append(") VALUES (");
        this.updateClause.append(" WHERE ");
        for (n2 = 0; n2 < this.columnCount; ++n2) {
            if (n2 != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append(":" + n2);
            if (n2 != 0) {
                this.updateClause.append(" AND ");
            }
            this.updateClause.append(this.rsmd.getColumnName(n2 + 1) + " = :" + n2);
        }
        this.insertClause.append(")");
        this.insertStmt = this.connection.prepareStatement(this.insertClause.substring(0, this.insertClause.length()));
        this.updateStmt = this.connection.prepareStatement(this.updateClause.substring(0, this.updateClause.length()));
        this.deleteStmt = this.connection.prepareStatement(this.deleteClause.substring(0, this.deleteClause.length()));
    }

    private boolean insertRow(OracleRow oracleRow) throws SQLException {
        this.insertStmt.clearParameters();
        for (int i2 = 1; i2 <= this.columnCount; ++i2) {
            Object object = null;
            Object object2 = object = oracleRow.isColumnChanged(i2) ? oracleRow.getModifiedColumn(i2) : oracleRow.getColumn(i2);
            if (object == null) {
                this.insertStmt.setNull(i2, this.rsmd.getColumnType(i2));
                oracleRow.markOriginalNull(i2, true);
                continue;
            }
            this.insertStmt.setObject(i2, object);
        }
        return this.insertStmt.executeUpdate() == 1;
    }

    private boolean updateRow(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        int n2;
        this.updateStmt.clearParameters();
        for (n2 = 1; n2 <= this.columnCount; ++n2) {
            Object object = null;
            Object object2 = object = oracleRow.isColumnChanged(n2) ? oracleRow.getModifiedColumn(n2) : oracleRow.getColumn(n2);
            if (object == null) {
                this.updateStmt.setNull(n2, this.rsmd.getColumnType(n2));
                continue;
            }
            if (object instanceof Reader) {
                OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.updateStmt;
                if (oracleRow.columnTypeInfo[n2 - 1][1] == 4) {
                    oraclePreparedStatement.setFormOfUse(n2, (short)2);
                } else if (oracleRow.columnTypeInfo[n2 - 1][1] == 3) {
                    oraclePreparedStatement.setFormOfUse(n2, (short)1);
                }
                this.updateStmt.setCharacterStream(n2, (Reader)object, oracleRow.columnTypeInfo[n2 - 1][0]);
                continue;
            }
            if (object instanceof InputStream) {
                if (oracleRow.columnTypeInfo[n2 - 1][1] == 2) {
                    this.updateStmt.setBinaryStream(n2, (InputStream)object, oracleRow.columnTypeInfo[n2 - 1][0]);
                    continue;
                }
                if (oracleRow.columnTypeInfo[n2 - 1][1] != 1) continue;
                this.updateStmt.setAsciiStream(n2, (InputStream)object, oracleRow.columnTypeInfo[n2 - 1][0]);
                continue;
            }
            this.updateStmt.setObject(n2, object);
        }
        for (n2 = 1; n2 <= this.columnCount; ++n2) {
            if (oracleRow.isOriginalNull(n2)) {
                return this.updateRowWithNull(rowSet, oracleRow);
            }
            this.updateStmt.setObject(n2 + this.columnCount, oracleRow.getColumn(n2));
        }
        return this.updateStmt.executeUpdate() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean updateRowWithNull(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        int n2;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.getTableName(rowSet) + " SET ");
        for (n2 = 1; n2 <= this.columnCount; ++n2) {
            if (n2 != 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.rsmd.getColumnName(n2) + " = :" + n2);
        }
        stringBuffer.append(" WHERE ");
        for (n2 = 1; n2 <= this.columnCount; ++n2) {
            if (n2 != 1) {
                stringBuffer.append(" AND ");
            }
            if (oracleRow.isOriginalNull(n2)) {
                stringBuffer.append(this.rsmd.getColumnName(n2) + " IS NULL ");
                continue;
            }
            stringBuffer.append(this.rsmd.getColumnName(n2) + " = :" + n2);
        }
        PreparedStatement preparedStatement = null;
        try {
            int n3;
            preparedStatement = this.connection.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
            for (n3 = 1; n3 <= this.columnCount; ++n3) {
                Object object = null;
                Object object2 = object = oracleRow.isColumnChanged(n3) ? oracleRow.getModifiedColumn(n3) : oracleRow.getColumn(n3);
                if (object == null) {
                    preparedStatement.setNull(n3, this.rsmd.getColumnType(n3));
                    continue;
                }
                if (object instanceof Reader) {
                    OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)preparedStatement;
                    if (oracleRow.columnTypeInfo[n3 - 1][1] == 4) {
                        oraclePreparedStatement.setFormOfUse(n3, (short)2);
                    } else if (oracleRow.columnTypeInfo[n3 - 1][1] == 3) {
                        oraclePreparedStatement.setFormOfUse(n3, (short)1);
                    }
                    preparedStatement.setCharacterStream(n3, (Reader)object, oracleRow.columnTypeInfo[n3 - 1][0]);
                    continue;
                }
                if (object instanceof InputStream) {
                    if (oracleRow.columnTypeInfo[n3 - 1][1] == 2) {
                        preparedStatement.setBinaryStream(n3, (InputStream)object, oracleRow.columnTypeInfo[n3 - 1][0]);
                        continue;
                    }
                    if (oracleRow.columnTypeInfo[n3 - 1][1] != 1) continue;
                    preparedStatement.setAsciiStream(n3, (InputStream)object, oracleRow.columnTypeInfo[n3 - 1][0]);
                    continue;
                }
                preparedStatement.setObject(n3, object);
            }
            int n4 = 1;
            for (n3 = 1; n3 <= this.columnCount; ++n3) {
                if (oracleRow.isOriginalNull(n3)) continue;
                preparedStatement.setObject(n4 + this.columnCount, oracleRow.getColumn(n3));
                ++n4;
            }
            bl = preparedStatement.executeUpdate() == 1;
            Object var10_11 = null;
            if (preparedStatement == null) return bl;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
        return bl;
    }

    private boolean deleteRow(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        this.deleteStmt.clearParameters();
        for (int i2 = 1; i2 <= this.columnCount; ++i2) {
            if (oracleRow.isOriginalNull(i2)) {
                return this.deleteRowWithNull(rowSet, oracleRow);
            }
            Object object = oracleRow.getColumn(i2);
            if (object == null) {
                this.deleteStmt.setNull(i2, this.rsmd.getColumnType(i2));
                continue;
            }
            this.deleteStmt.setObject(i2, object);
        }
        return this.deleteStmt.executeUpdate() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean deleteRowWithNull(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + this.getTableName(rowSet) + " WHERE ");
        for (int i2 = 1; i2 <= this.columnCount; ++i2) {
            if (i2 != 1) {
                stringBuffer.append(" AND ");
            }
            if (oracleRow.isOriginalNull(i2)) {
                stringBuffer.append(this.rsmd.getColumnName(i2) + " IS NULL ");
                continue;
            }
            stringBuffer.append(this.rsmd.getColumnName(i2) + " = :" + i2);
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.connection.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
            int n2 = 1;
            for (int i3 = 1; i3 <= this.columnCount; ++i3) {
                if (oracleRow.isOriginalNull(i3)) continue;
                preparedStatement.setObject(n2++, oracleRow.getColumn(i3));
            }
            bl = preparedStatement.executeUpdate() == 1;
            Object var9_9 = null;
            if (preparedStatement == null) return bl;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
        return bl;
    }

    public synchronized boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)rowSetInternal;
        this.connection = ((OracleCachedRowSetReader)oracleCachedRowSet.getReader()).getConnection(rowSetInternal);
        if (this.connection == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 342);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(false);
        }
        try {
            this.connection.setTransactionIsolation(oracleCachedRowSet.getTransactionIsolation());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initSQLStatement(oracleCachedRowSet);
        if (this.columnCount < 1) {
            this.connection.close();
            return true;
        }
        boolean bl = oracleCachedRowSet.getShowDeleted();
        oracleCachedRowSet.setShowDeleted(true);
        oracleCachedRowSet.beforeFirst();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        OracleRow oracleRow = null;
        while (oracleCachedRowSet.next()) {
            if (oracleCachedRowSet.rowInserted()) {
                if (oracleCachedRowSet.rowDeleted()) continue;
                oracleRow = oracleCachedRowSet.getCurrentRow();
                bl3 = this.insertRow(oracleRow) || bl3;
                continue;
            }
            if (oracleCachedRowSet.rowUpdated()) {
                oracleRow = oracleCachedRowSet.getCurrentRow();
                bl2 = this.updateRow(oracleCachedRowSet, oracleRow) || bl2;
                continue;
            }
            if (!oracleCachedRowSet.rowDeleted()) continue;
            oracleRow = oracleCachedRowSet.getCurrentRow();
            bl4 = this.deleteRow(oracleCachedRowSet, oracleRow) || bl4;
        }
        if (bl2 && bl3 && bl4) {
            this.connection.commit();
            oracleCachedRowSet.setOriginal();
        } else {
            this.connection.rollback();
        }
        this.insertStmt.close();
        this.updateStmt.close();
        this.deleteStmt.close();
        if (!oracleCachedRowSet.isConnectionStayingOpen()) {
            this.connection.close();
        }
        oracleCachedRowSet.setShowDeleted(bl);
        return true;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

