/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.ons.Notification;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;

class OracleFailoverEventHandlerThread
extends Thread {
    private Notification event = null;
    private OracleConnectionCacheManager cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:28:36_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    OracleFailoverEventHandlerThread() throws SQLException {
    }

    public void run() {
        Subscriber subscriber = null;
        while (this.cacheManager.failoverEnabledCacheExists()) {
            try {
                subscriber = (Subscriber)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        try {
                            return new Subscriber("(%\"eventType=database/event/service\")|(%\"eventType=database/event/host\")", "", 30000L);
                        }
                        catch (SubscriptionException subscriptionException) {
                            return null;
                        }
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            if (subscriber != null) {
                try {
                    while (this.cacheManager.failoverEnabledCacheExists()) {
                        this.event = subscriber.receive(true);
                        if (this.event == null) continue;
                        this.handleEvent(this.event);
                    }
                }
                catch (ONSException oNSException) {
                    subscriber.close();
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void handleEvent(Notification notification) {
        try {
            int n2 = 0;
            if (notification.type().equalsIgnoreCase("database/event/service")) {
                n2 = 256;
            } else if (notification.type().equalsIgnoreCase("database/event/host")) {
                n2 = 512;
            }
            if (n2 != 0) {
                this.cacheManager.verifyAndHandleEvent(n2, notification.body());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

