/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.transaction.xa.XAResource;
import oracle.jdbc.driver.ClosedConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.internal.XSEventListener;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMEZONETAB;

class LogicalConnection
extends OracleConnection {
    static final ClosedConnection closedConnection = new ClosedConnection();
    PhysicalConnection internalConnection;
    OraclePooledConnection pooledConnection;
    boolean closed;
    OracleCloseCallback closeCallback = null;
    Object privateData = null;
    long startTime = 0L;
    OracleConnectionCacheCallback connectionCacheCallback = null;
    Object connectionCacheCallbackUserObj = null;
    int callbackFlag = 0;
    int releasePriority = 0;
    int heartbeatCount = 0;
    int heartbeatLastCount = 0;
    int heartbeatNoChangeCount = 0;
    boolean isAbandonedTimeoutEnabled = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:28:36_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    LogicalConnection(OraclePooledConnection oraclePooledConnection, PhysicalConnection physicalConnection, boolean bl) throws SQLException {
        this.internalConnection = physicalConnection;
        this.pooledConnection = oraclePooledConnection;
        this.connection = this.internalConnection;
        this.connection.setWrapper(this);
        this.closed = false;
        this.internalConnection.setAutoCommit(bl);
    }

    void registerHeartbeat() throws SQLException {
        if (this.isAbandonedTimeoutEnabled) {
            try {
                ++this.heartbeatCount;
            }
            catch (ArithmeticException arithmeticException) {
                this.heartbeatCount = 0;
            }
        }
    }

    public int getHeartbeatNoChangeCount() throws SQLException {
        if (this.heartbeatCount == this.heartbeatLastCount) {
            ++this.heartbeatNoChangeCount;
        } else {
            this.heartbeatLastCount = this.heartbeatCount;
            this.heartbeatNoChangeCount = 0;
        }
        return this.heartbeatNoChangeCount;
    }

    public oracle.jdbc.internal.OracleConnection physicalConnectionWithin() {
        return this.internalConnection;
    }

    public synchronized void registerCloseCallback(OracleCloseCallback oracleCloseCallback, Object object) {
        this.closeCallback = oracleCloseCallback;
        this.privateData = object;
    }

    public Connection _getPC() {
        return this.internalConnection;
    }

    public synchronized boolean isLogicalConnection() {
        return true;
    }

    public oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        return this.internalConnection;
    }

    public Connection getLogicalConnection(OraclePooledConnection oraclePooledConnection, boolean bl) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 153);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public void getPropertyForPooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 153);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public synchronized void close() throws SQLException {
        this.closeInternal(true);
    }

    public void closeInternal(boolean bl) throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.closeCallback != null) {
            this.closeCallback.beforeClose(this, this.privateData);
        }
        this.internalConnection.closeLogicalConnection();
        this.startTime = 0L;
        this.closed = true;
        if (this.pooledConnection != null && bl) {
            this.pooledConnection.logicalClose();
        }
        this.internalConnection = closedConnection;
        this.connection = closedConnection;
        if (this.closeCallback != null) {
            this.closeCallback.afterClose(this.privateData);
        }
    }

    public void cleanupAndClose(boolean bl) throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        PhysicalConnection physicalConnection = this.internalConnection;
        OraclePooledConnection oraclePooledConnection = this.pooledConnection;
        this.internalConnection = closedConnection;
        this.connection = closedConnection;
        this.startTime = 0L;
        if (this.closeCallback != null) {
            this.closeCallback.beforeClose(this, this.privateData);
        }
        physicalConnection.cleanupAndClose();
        physicalConnection.closeLogicalConnection();
        if (oraclePooledConnection != null && bl) {
            oraclePooledConnection.logicalClose();
        }
        if (this.closeCallback != null) {
            this.closeCallback.afterClose(this.privateData);
        }
    }

    public void abort() throws SQLException {
        if (this.closed) {
            return;
        }
        this.internalConnection.abort();
        this.closed = true;
        this.internalConnection = closedConnection;
        this.connection = closedConnection;
    }

    public synchronized void close(Properties properties) throws SQLException {
        if (this.pooledConnection != null) {
            this.pooledConnection.cachedConnectionAttributes.clear();
            this.pooledConnection.cachedConnectionAttributes.putAll((Map<?, ?>)properties);
        }
        this.close();
    }

    public synchronized void close(int n2) throws SQLException {
        if ((n2 & 0x1000) != 0) {
            if (this.pooledConnection != null) {
                this.pooledConnection.closeOption = n2;
            }
            this.close();
            return;
        }
        if ((n2 & 1) != 0) {
            this.internalConnection.close(1);
        }
    }

    public synchronized void applyConnectionAttributes(Properties properties) throws SQLException {
        if (this.pooledConnection != null) {
            this.pooledConnection.cachedConnectionAttributes.putAll((Map<?, ?>)properties);
        }
    }

    public synchronized Properties getConnectionAttributes() throws SQLException {
        if (this.pooledConnection != null) {
            return this.pooledConnection.cachedConnectionAttributes;
        }
        return null;
    }

    public synchronized Properties getUnMatchedConnectionAttributes() throws SQLException {
        if (this.pooledConnection != null) {
            return this.pooledConnection.unMatchedCachedConnAttr;
        }
        return null;
    }

    public synchronized void setAbandonedTimeoutEnabled(boolean bl) throws SQLException {
        this.isAbandonedTimeoutEnabled = true;
    }

    public synchronized void registerConnectionCacheCallback(OracleConnectionCacheCallback oracleConnectionCacheCallback, Object object, int n2) throws SQLException {
        this.connectionCacheCallback = oracleConnectionCacheCallback;
        this.connectionCacheCallbackUserObj = object;
        this.callbackFlag = n2;
    }

    public OracleConnectionCacheCallback getConnectionCacheCallbackObj() throws SQLException {
        return this.connectionCacheCallback;
    }

    public Object getConnectionCacheCallbackPrivObj() throws SQLException {
        return this.connectionCacheCallbackUserObj;
    }

    public int getConnectionCacheCallbackFlag() throws SQLException {
        return this.callbackFlag;
    }

    public synchronized void setConnectionReleasePriority(int n2) throws SQLException {
        this.releasePriority = n2;
    }

    public int getConnectionReleasePriority() throws SQLException {
        return this.releasePriority;
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.closed;
    }

    public void setStartTime(long l2) throws SQLException {
        if (l2 <= 0L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.startTime = l2;
    }

    public long getStartTime() throws SQLException {
        return this.startTime;
    }

    public String getDatabaseTimeZone() throws SQLException {
        return this.internalConnection.getDatabaseTimeZone();
    }

    public Properties getServerSessionInfo() throws SQLException {
        return this.internalConnection.getServerSessionInfo();
    }

    public Object getClientData(Object object) {
        return this.internalConnection.getClientData(object);
    }

    public Object setClientData(Object object, Object object2) {
        return this.internalConnection.setClientData(object, object2);
    }

    public Object removeClientData(Object object) {
        return this.internalConnection.removeClientData(object);
    }

    public void setClientIdentifier(String string) throws SQLException {
        this.internalConnection.setClientIdentifier(string);
    }

    public void clearClientIdentifier(String string) throws SQLException {
        this.internalConnection.clearClientIdentifier(string);
    }

    public short getStructAttrNCsId() throws SQLException {
        return this.internalConnection.getStructAttrNCsId();
    }

    public Map getTypeMap() throws SQLException {
        return this.internalConnection.getTypeMap();
    }

    public Properties getDBAccessProperties() throws SQLException {
        return this.internalConnection.getDBAccessProperties();
    }

    public Properties getOCIHandles() throws SQLException {
        return this.internalConnection.getOCIHandles();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.internalConnection.getDatabaseProductVersion();
    }

    public void cancel() throws SQLException {
        this.registerHeartbeat();
        this.internalConnection.cancel();
    }

    public String getURL() throws SQLException {
        return this.internalConnection.getURL();
    }

    public boolean getIncludeSynonyms() {
        return this.internalConnection.getIncludeSynonyms();
    }

    public boolean getRemarksReporting() {
        return this.internalConnection.getRemarksReporting();
    }

    public boolean getRestrictGetTables() {
        return this.internalConnection.getRestrictGetTables();
    }

    public short getVersionNumber() throws SQLException {
        return this.internalConnection.getVersionNumber();
    }

    public Map getJavaObjectTypeMap() {
        return this.internalConnection.getJavaObjectTypeMap();
    }

    public void setJavaObjectTypeMap(Map map) {
        this.internalConnection.setJavaObjectTypeMap(map);
    }

    public BfileDBAccess createBfileDBAccess() throws SQLException {
        return this.internalConnection.createBfileDBAccess();
    }

    public BlobDBAccess createBlobDBAccess() throws SQLException {
        return this.internalConnection.createBlobDBAccess();
    }

    public ClobDBAccess createClobDBAccess() throws SQLException {
        return this.internalConnection.createClobDBAccess();
    }

    public void setDefaultFixedString(boolean bl) {
        this.internalConnection.setDefaultFixedString(bl);
    }

    public boolean getTimestamptzInGmt() {
        return this.internalConnection.getTimestamptzInGmt();
    }

    public boolean getDefaultFixedString() {
        return this.internalConnection.getDefaultFixedString();
    }

    public oracle.jdbc.OracleConnection getWrapper() {
        return this;
    }

    public Class classForNameAndSchema(String string, String string2) throws ClassNotFoundException {
        return this.internalConnection.classForNameAndSchema(string, string2);
    }

    public void setFDO(byte[] byArray) throws SQLException {
        this.internalConnection.setFDO(byArray);
    }

    public byte[] getFDO(boolean bl) throws SQLException {
        return this.internalConnection.getFDO(bl);
    }

    public boolean getBigEndian() throws SQLException {
        return this.internalConnection.getBigEndian();
    }

    public Object getDescriptor(byte[] byArray) {
        return this.internalConnection.getDescriptor(byArray);
    }

    public void putDescriptor(byte[] byArray, Object object) throws SQLException {
        this.internalConnection.putDescriptor(byArray, object);
    }

    public void removeDescriptor(String string) {
        this.internalConnection.removeDescriptor(string);
    }

    public void removeAllDescriptor() {
        this.internalConnection.removeAllDescriptor();
    }

    public int numberOfDescriptorCacheEntries() {
        return this.internalConnection.numberOfDescriptorCacheEntries();
    }

    public Enumeration descriptorCacheKeys() {
        return this.internalConnection.descriptorCacheKeys();
    }

    public void getOracleTypeADT(OracleTypeADT oracleTypeADT) throws SQLException {
        this.internalConnection.getOracleTypeADT(oracleTypeADT);
    }

    public short getDbCsId() throws SQLException {
        return this.internalConnection.getDbCsId();
    }

    public short getJdbcCsId() throws SQLException {
        return this.internalConnection.getJdbcCsId();
    }

    public short getNCharSet() {
        return this.internalConnection.getNCharSet();
    }

    public ResultSet newArrayDataResultSet(Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        return this.internalConnection.newArrayDataResultSet(datumArray, l2, n2, map);
    }

    public ResultSet newArrayDataResultSet(ARRAY aRRAY, long l2, int n2, Map map) throws SQLException {
        return this.internalConnection.newArrayDataResultSet(aRRAY, l2, n2, map);
    }

    public ResultSet newArrayLocatorResultSet(ArrayDescriptor arrayDescriptor, byte[] byArray, long l2, int n2, Map map) throws SQLException {
        return this.internalConnection.newArrayLocatorResultSet(arrayDescriptor, byArray, l2, n2, map);
    }

    public ResultSetMetaData newStructMetaData(StructDescriptor structDescriptor) throws SQLException {
        return this.internalConnection.newStructMetaData(structDescriptor);
    }

    public void getForm(OracleTypeADT oracleTypeADT, OracleTypeCLOB oracleTypeCLOB, int n2) throws SQLException {
        this.internalConnection.getForm(oracleTypeADT, oracleTypeCLOB, n2);
    }

    public int CHARBytesToJavaChars(byte[] byArray, int n2, char[] cArray) throws SQLException {
        return this.internalConnection.CHARBytesToJavaChars(byArray, n2, cArray);
    }

    public int NCHARBytesToJavaChars(byte[] byArray, int n2, char[] cArray) throws SQLException {
        return this.internalConnection.NCHARBytesToJavaChars(byArray, n2, cArray);
    }

    public boolean IsNCharFixedWith() {
        return this.internalConnection.IsNCharFixedWith();
    }

    public short getDriverCharSet() {
        return this.internalConnection.getDriverCharSet();
    }

    public int getC2SNlsRatio() {
        return this.internalConnection.getC2SNlsRatio();
    }

    public int getMaxCharSize() throws SQLException {
        return this.internalConnection.getMaxCharSize();
    }

    public int getMaxCharbyteSize() {
        return this.internalConnection.getMaxCharbyteSize();
    }

    public int getMaxNCharbyteSize() {
        return this.internalConnection.getMaxNCharbyteSize();
    }

    public boolean isCharSetMultibyte(short s2) {
        return this.internalConnection.isCharSetMultibyte(s2);
    }

    public int javaCharsToCHARBytes(char[] cArray, int n2, byte[] byArray) throws SQLException {
        return this.internalConnection.javaCharsToCHARBytes(cArray, n2, byArray);
    }

    public int javaCharsToNCHARBytes(char[] cArray, int n2, byte[] byArray) throws SQLException {
        return this.internalConnection.javaCharsToNCHARBytes(cArray, n2, byArray);
    }

    public int getStmtCacheSize() {
        return this.internalConnection.getStmtCacheSize();
    }

    public int getStatementCacheSize() throws SQLException {
        return this.internalConnection.getStatementCacheSize();
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.internalConnection.getImplicitCachingEnabled();
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.internalConnection.getExplicitCachingEnabled();
    }

    public void purgeImplicitCache() throws SQLException {
        this.internalConnection.purgeImplicitCache();
    }

    public void purgeExplicitCache() throws SQLException {
        this.internalConnection.purgeExplicitCache();
    }

    public PreparedStatement getStatementWithKey(String string) throws SQLException {
        return this.internalConnection.getStatementWithKey(string);
    }

    public CallableStatement getCallWithKey(String string) throws SQLException {
        return this.internalConnection.getCallWithKey(string);
    }

    public boolean isStatementCacheInitialized() {
        return this.internalConnection.isStatementCacheInitialized();
    }

    public void setTypeMap(Map map) {
        this.internalConnection.setTypeMap(map);
    }

    public String getProtocolType() {
        return this.internalConnection.getProtocolType();
    }

    public void setTxnMode(int n2) {
        this.internalConnection.setTxnMode(n2);
    }

    public int getTxnMode() {
        return this.internalConnection.getTxnMode();
    }

    public int getHeapAllocSize() throws SQLException {
        return this.internalConnection.getHeapAllocSize();
    }

    public int getOCIEnvHeapAllocSize() throws SQLException {
        return this.internalConnection.getOCIEnvHeapAllocSize();
    }

    public CLOB createClob(byte[] byArray) throws SQLException {
        this.registerHeartbeat();
        return this.internalConnection.createClob(byArray);
    }

    public CLOB createClobWithUnpickledBytes(byte[] byArray) throws SQLException {
        this.registerHeartbeat();
        return this.internalConnection.createClobWithUnpickledBytes(byArray);
    }

    public CLOB createClob(byte[] byArray, short s2) throws SQLException {
        this.registerHeartbeat();
        return this.internalConnection.createClob(byArray, s2);
    }

    public BLOB createBlob(byte[] byArray) throws SQLException {
        this.registerHeartbeat();
        return this.internalConnection.createBlob(byArray);
    }

    public BLOB createBlobWithUnpickledBytes(byte[] byArray) throws SQLException {
        this.registerHeartbeat();
        return this.internalConnection.createBlobWithUnpickledBytes(byArray);
    }

    public BFILE createBfile(byte[] byArray) throws SQLException {
        this.registerHeartbeat();
        return this.internalConnection.createBfile(byArray);
    }

    public boolean isDescriptorSharable(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        return this.internalConnection.isDescriptorSharable(oracleConnection);
    }

    public OracleStatement refCursorCursorToStatement(int n2) throws SQLException {
        return this.internalConnection.refCursorCursorToStatement(n2);
    }

    public long getTdoCState(String string, String string2) throws SQLException {
        return this.internalConnection.getTdoCState(string, string2);
    }

    public Datum toDatum(CustomDatum customDatum) throws SQLException {
        return this.internalConnection.toDatum(customDatum);
    }

    public XAResource getXAResource() throws SQLException {
        return this.pooledConnection.getXAResource();
    }

    public void setApplicationContext(String string, String string2, String string3) throws SQLException {
        this.internalConnection.setApplicationContext(string, string2, string3);
    }

    public void clearAllApplicationContext(String string) throws SQLException {
        this.internalConnection.clearAllApplicationContext(string);
    }

    public boolean isV8Compatible() throws SQLException {
        return this.getMapDateToTimestamp();
    }

    public boolean getMapDateToTimestamp() {
        return this.internalConnection.getMapDateToTimestamp();
    }

    public byte[] createLightweightSession(String string, KeywordValueLong[] keywordValueLongArray, int n2, KeywordValueLong[][] keywordValueLongArray2, int[] nArray) throws SQLException {
        return this.internalConnection.createLightweightSession(string, keywordValueLongArray, n2, keywordValueLongArray2, nArray);
    }

    public void executeLightweightSessionRoundtrip(int n2, byte[] byArray, KeywordValueLong[] keywordValueLongArray, int n3, KeywordValueLong[][] keywordValueLongArray2, int[] nArray) throws SQLException {
        this.internalConnection.executeLightweightSessionRoundtrip(n2, byArray, keywordValueLongArray, n3, keywordValueLongArray2, nArray);
    }

    public void executeLightweightSessionPiggyback(int n2, byte[] byArray, KeywordValueLong[] keywordValueLongArray, int n3) throws SQLException {
        this.internalConnection.executeLightweightSessionPiggyback(n2, byArray, keywordValueLongArray, n3);
    }

    public void doXSNamespaceOp(OracleConnection.XSOperationCode xSOperationCode, byte[] byArray, XSNamespace[] xSNamespaceArray, XSNamespace[][] xSNamespaceArray2) throws SQLException {
        this.internalConnection.doXSNamespaceOp(xSOperationCode, byArray, xSNamespaceArray, xSNamespaceArray2);
    }

    public void doXSNamespaceOp(OracleConnection.XSOperationCode xSOperationCode, byte[] byArray, XSNamespace[] xSNamespaceArray) throws SQLException {
        this.internalConnection.doXSNamespaceOp(xSOperationCode, byArray, xSNamespaceArray);
    }

    public BLOB createTemporaryBlob(Connection connection, boolean bl, int n2) throws SQLException {
        this.registerHeartbeat();
        return this.internalConnection.createTemporaryBlob(connection, bl, n2);
    }

    public CLOB createTemporaryClob(Connection connection, boolean bl, int n2, short s2) throws SQLException {
        this.registerHeartbeat();
        return this.internalConnection.createTemporaryClob(connection, bl, n2, s2);
    }

    public String getDefaultSchemaNameForNamedTypes() throws SQLException {
        return this.internalConnection.getDefaultSchemaNameForNamedTypes();
    }

    public boolean isUsable() {
        return !this.closed && this.internalConnection.isUsable();
    }

    public byte getInstanceProperty(OracleConnection.InstanceProperty instanceProperty) throws SQLException {
        return this.internalConnection.getInstanceProperty(instanceProperty);
    }

    public void setUsable(boolean bl) {
        this.internalConnection.setUsable(bl);
    }

    public int getTimezoneVersionNumber() throws SQLException {
        return this.internalConnection.getTimezoneVersionNumber();
    }

    public TIMEZONETAB getTIMEZONETAB() throws SQLException {
        return this.internalConnection.getTIMEZONETAB();
    }

    public void addXSEventListener(XSEventListener xSEventListener) throws SQLException {
        this.internalConnection.addXSEventListener(xSEventListener);
    }

    public void addXSEventListener(XSEventListener xSEventListener, Executor executor) throws SQLException {
        this.internalConnection.addXSEventListener(xSEventListener, executor);
    }

    public void removeXSEventListener(XSEventListener xSEventListener) throws SQLException {
        this.internalConnection.addXSEventListener(xSEventListener);
    }

    public OracleConnection.BufferCacheStatistics getByteBufferCacheStatistics() {
        return this.internalConnection.getByteBufferCacheStatistics();
    }

    public OracleConnection.BufferCacheStatistics getCharBufferCacheStatistics() {
        return this.internalConnection.getCharBufferCacheStatistics();
    }
}

