/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.ws.commons.schema.SchemaBuilder;
import org.apache.ws.commons.schema.TypeReceiver;
import org.apache.ws.commons.schema.ValidationEventHandler;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlSchemaCollection {
    Map namespaces = new HashMap();
    String baseUri = null;
    Map inScopeNamespaces = new HashMap();
    XmlSchema xsd = new XmlSchema("http://www.w3.org/2001/XMLSchema", this);
    Map unresolvedTypes = new HashMap();

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void init() {
        this.addSimpleType(this.xsd, Constants.XSD_STRING.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_BOOLEAN.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_FLOAT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DOUBLE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_QNAME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DECIMAL.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DURATION.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DATE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_TIME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DATETIME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DAY.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_MONTH.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_MONTHDAY.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_YEAR.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_YEARMONTH.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NOTATION.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_HEXBIN.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_BASE64.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ANYURI.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_LONG.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_SHORT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_BYTE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_INTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_INT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_POSITIVEINTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NEGATIVEINTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NONPOSITIVEINTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NONNEGATIVEINTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_UNSIGNEDBYTE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_UNSIGNEDINT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_UNSIGNEDLONG.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_UNSIGNEDSHORT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NAME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NORMALIZEDSTRING.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NCNAME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NMTOKEN.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NMTOKENS.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ENTITY.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ENTITIES.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ID.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_IDREF.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_IDREFS.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_LANGUAGE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_TOKEN.getLocalPart());
        this.namespaces.put("http://www.w3.org/2001/XMLSchema", this.xsd);
    }

    private void addSimpleType(XmlSchema schema, String typeName) {
        XmlSchemaSimpleType type = new XmlSchemaSimpleType(schema);
        type.setName(typeName);
        schema.addType(type);
    }

    public XmlSchema read(Reader r, ValidationEventHandler veh) {
        return this.read(new InputSource(r), veh);
    }

    public XmlSchema read(InputSource inputSource, ValidationEventHandler veh) {
        try {
            DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
            docFac.setNamespaceAware(true);
            DocumentBuilder builder = docFac.newDocumentBuilder();
            Document doc = builder.parse(inputSource);
            return this.read(doc, inputSource.getSystemId(), veh);
        }
        catch (ParserConfigurationException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (IOException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (SAXException e) {
            throw new XmlSchemaException(e.getMessage());
        }
    }

    public XmlSchema read(Source source, ValidationEventHandler veh) {
        try {
            TransformerFactory trFac = TransformerFactory.newInstance();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            Transformer tr = trFac.newTransformer();
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("omit-xml-declaration", "yes");
            tr.transform(source, result);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            return this.read(new InputSource(in), veh);
        }
        catch (TransformerException e) {
            throw new XmlSchemaException(e.getMessage());
        }
    }

    public XmlSchema read(Document doc, ValidationEventHandler veh) {
        SchemaBuilder builder = new SchemaBuilder(this);
        return builder.build(doc, null, veh);
    }

    public XmlSchema read(Element elem) {
        SchemaBuilder builder = new SchemaBuilder(this);
        return builder.handleXmlSchemaElement(elem, null);
    }

    public XmlSchema read(Document doc, String uri, ValidationEventHandler veh) {
        SchemaBuilder builder = new SchemaBuilder(this);
        return builder.build(doc, uri, veh);
    }

    public XmlSchema read(Element elem, String uri) {
        SchemaBuilder builder = new SchemaBuilder(this);
        return builder.handleXmlSchemaElement(elem, uri);
    }

    public XmlSchemaCollection() {
        this.init();
    }

    public XmlSchemaElement getElementByQName(QName qname) {
        XmlSchema schema = (XmlSchema)this.namespaces.get(qname.getNamespaceURI());
        if (schema == null) {
            return null;
        }
        return schema.getElementByName(qname);
    }

    public XmlSchemaType getTypeByQName(QName schemaTypeName) {
        XmlSchema schema = (XmlSchema)this.namespaces.get(schemaTypeName.getNamespaceURI());
        if (schema == null) {
            return null;
        }
        return schema.getTypeByName(schemaTypeName);
    }

    void addUnresolvedType(QName type, TypeReceiver receiver) {
        ArrayList<TypeReceiver> receivers = (ArrayList<TypeReceiver>)this.unresolvedTypes.get(type);
        if (receivers == null) {
            receivers = new ArrayList<TypeReceiver>();
            this.unresolvedTypes.put(type, receivers);
        }
        receivers.add(receiver);
    }

    void resolveType(QName typeName, XmlSchemaType type) {
        ArrayList receivers = (ArrayList)this.unresolvedTypes.get(typeName);
        if (receivers == null) {
            return;
        }
        Iterator i = receivers.iterator();
        while (i.hasNext()) {
            TypeReceiver receiver = (TypeReceiver)i.next();
            receiver.setType(type);
        }
        this.unresolvedTypes.remove(typeName);
    }

    public String getNamespaceForPrefix(String prefix) {
        return (String)this.inScopeNamespaces.get(prefix);
    }

    public void mapNamespace(String prefix, String namespaceURI) {
        this.inScopeNamespaces.put(prefix, namespaceURI);
    }
}

