/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.Locale;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Hierarchy;
import mondrian.olap.Util;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.olap4j.MondrianOlap4jSchema;
import org.olap4j.OlapException;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MondrianOlap4jDimension
implements org.olap4j.metadata.Dimension,
Named {
    private final MondrianOlap4jSchema olap4jSchema;
    private final Dimension dimension;

    MondrianOlap4jDimension(MondrianOlap4jSchema olap4jSchema, Dimension dimension) {
        this.olap4jSchema = olap4jSchema;
        this.dimension = dimension;
    }

    public boolean equals(Object obj) {
        return obj instanceof MondrianOlap4jDimension && this.dimension.equals(((MondrianOlap4jDimension)obj).dimension);
    }

    public int hashCode() {
        return this.dimension.hashCode();
    }

    public NamedList<org.olap4j.metadata.Hierarchy> getHierarchies() {
        NamedListImpl list = new NamedListImpl();
        MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        for (Hierarchy hierarchy : this.dimension.getHierarchies()) {
            list.add((Object)olap4jConnection.toOlap4j(hierarchy));
        }
        return Olap4jUtil.cast((NamedList)list);
    }

    public org.olap4j.metadata.Hierarchy getDefaultHierarchy() {
        return (org.olap4j.metadata.Hierarchy)this.getHierarchies().get(0);
    }

    public Dimension.Type getDimensionType() throws OlapException {
        DimensionType dimensionType = this.dimension.getDimensionType();
        switch (dimensionType) {
            case StandardDimension: {
                return Dimension.Type.OTHER;
            }
            case MeasuresDimension: {
                return Dimension.Type.MEASURE;
            }
            case TimeDimension: {
                return Dimension.Type.TIME;
            }
        }
        throw Util.unexpected(dimensionType);
    }

    public String getName() {
        return this.dimension.getName();
    }

    public String getUniqueName() {
        return this.dimension.getUniqueName();
    }

    public String getCaption(Locale locale) {
        return this.dimension.getCaption();
    }

    public String getDescription(Locale locale) {
        return this.dimension.getDescription();
    }
}

