/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TextReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.undo.ITransformation;
import java.awt.Point;
import java.awt.Rectangle;

public class ElementTransformation
implements UndoOperation,
ITransformation {
    public ReportElement element;
    public Rectangle oldBounds;
    public Rectangle newBounds;
    public Band oldBand;
    public Band newBand;
    public CrosstabCell oldCell;
    public CrosstabCell newCell;
    private Object oldFontSize;
    private Object newFontSize;

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof ReportElement && this.element != null) {
            isEqual = this.element.equals((ReportElement)obj);
        }
        return isEqual;
    }

    public void undo() {
        this.element.setPosition(new Point(this.oldBounds.x, this.oldBounds.y));
        this.element.setWidth(this.oldBounds.width);
        this.element.setHeight(this.oldBounds.height);
        this.element.updateBounds();
        if (this.oldBand != null) {
            this.element.setBand(this.oldBand);
        }
        if (this.oldCell != null) {
            this.element.setCell(this.oldCell);
        }
        if (this.element.getCell() != null) {
            this.element.setRelativePosition(new Point(this.element.getPosition().x - this.element.getCell().getLeft() - 10, this.element.getPosition().y - this.element.getCell().getTop() - 10));
        }
        if (this.element instanceof TextReportElement) {
            try {
                ((TextReportElement)this.element).getIReportFont().setPropertyValue("fontSize", this.oldFontSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void redo() {
        if (this.element == null || this.newBounds == null) {
            return;
        }
        this.element.setPosition(new Point(this.newBounds.x, this.newBounds.y));
        this.element.setWidth(this.newBounds.width);
        this.element.setHeight(this.newBounds.height);
        this.element.updateBounds();
        if (this.newBand != null) {
            this.element.setBand(this.newBand);
        }
        if (this.newCell != null) {
            this.element.setCell(this.newCell);
        }
        if (this.element.getCell() != null) {
            this.element.setRelativePosition(new Point(this.element.getPosition().x - this.element.getCell().getLeft() - 10, this.element.getPosition().y - this.element.getCell().getTop() - 10));
        }
        if (this.element instanceof TextReportElement) {
            try {
                ((TextReportElement)this.element).getIReportFont().setPropertyValue("fontSize", this.newFontSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void captureCurrent(Object obj) {
        ReportElement element;
        this.element = element = (ReportElement)obj;
        this.oldBounds = new Rectangle(element.getBounds());
        this.oldBand = element.getBand();
        this.oldCell = element.getCell();
        if (element instanceof TextReportElement) {
            this.oldFontSize = ((TextReportElement)element).getIReportFont().getPropertyValue("fontSize");
        }
    }

    public void captureModified(Object obj) {
        ReportElement element = (ReportElement)obj;
        this.newBounds = new Rectangle(element.getBounds());
        this.newBand = element.getBand();
        this.newCell = element.getCell();
        if (element instanceof TextReportElement) {
            this.newFontSize = ((TextReportElement)element).getIReportFont().getPropertyValue("fontSize");
        }
    }
}

