/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.syntax;

import javax.swing.text.Segment;
import org.syntax.jedit.KeywordMap;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class JRTokenMarker
extends TokenMarker {
    public byte FIELD_KEYWORD = 0;
    public byte VARIABLE_KEYWORD = 0;
    public byte PARAMETER_KEYWORD = 0;
    private static KeywordMap cKeywords;
    private boolean cpp;
    protected KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public JRTokenMarker() {
        this(JRTokenMarker.getKeywords());
    }

    public JRTokenMarker(KeywordMap keywords) {
        this.keywords = keywords;
        this.FIELD_KEYWORD = (byte)6;
        this.VARIABLE_KEYWORD = (byte)7;
        this.PARAMETER_KEYWORD = (byte)8;
    }

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block21: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            if (!this.cpp) continue block21;
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)7);
                            this.lastOffset = this.lastKeyword = length;
                            break block21;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == offset) {
                                if (this.doKeyword(line, i, c)) break;
                                backslash = false;
                                this.addToken(i1 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) continue block21;
                            break;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block21;
                            switch (array[i1]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (length - i > 2 && array[i + 2] == '*') {
                                        token = (byte)2;
                                        break;
                                    }
                                    token = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.addToken(length - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = length;
                                    break block21;
                                }
                            }
                            continue block21;
                        }
                        default: {
                            backslash = false;
                            if (Character.isLetterOrDigit(c) || c == '_') continue block21;
                            this.doKeyword(line, i, c);
                            break;
                        }
                    }
                    continue block21;
                }
                case 1: 
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block21;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block21;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block21;
                    }
                    if (c != '\"') continue block21;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block21;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block21;
                    }
                    if (c != '\'') continue block21;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block21;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (cKeywords == null) {
            cKeywords = new KeywordMap(false);
            cKeywords.add("package", (byte)7);
            cKeywords.add("import", (byte)7);
            cKeywords.add("byte", (byte)8);
            cKeywords.add("char", (byte)8);
            cKeywords.add("short", (byte)8);
            cKeywords.add("int", (byte)8);
            cKeywords.add("long", (byte)8);
            cKeywords.add("float", (byte)8);
            cKeywords.add("double", (byte)8);
            cKeywords.add("boolean", (byte)8);
            cKeywords.add("void", (byte)8);
            cKeywords.add("class", (byte)8);
            cKeywords.add("interface", (byte)8);
            cKeywords.add("abstract", (byte)6);
            cKeywords.add("final", (byte)6);
            cKeywords.add("private", (byte)6);
            cKeywords.add("protected", (byte)6);
            cKeywords.add("public", (byte)6);
            cKeywords.add("static", (byte)6);
            cKeywords.add("synchronized", (byte)6);
            cKeywords.add("native", (byte)6);
            cKeywords.add("volatile", (byte)6);
            cKeywords.add("transient", (byte)6);
            cKeywords.add("break", (byte)6);
            cKeywords.add("case", (byte)6);
            cKeywords.add("continue", (byte)6);
            cKeywords.add("default", (byte)6);
            cKeywords.add("do", (byte)6);
            cKeywords.add("else", (byte)6);
            cKeywords.add("for", (byte)6);
            cKeywords.add("if", (byte)6);
            cKeywords.add("instanceof", (byte)6);
            cKeywords.add("new", (byte)6);
            cKeywords.add("return", (byte)6);
            cKeywords.add("switch", (byte)6);
            cKeywords.add("while", (byte)6);
            cKeywords.add("throw", (byte)6);
            cKeywords.add("try", (byte)6);
            cKeywords.add("catch", (byte)6);
            cKeywords.add("extends", (byte)6);
            cKeywords.add("finally", (byte)6);
            cKeywords.add("implements", (byte)6);
            cKeywords.add("throws", (byte)6);
            cKeywords.add("this", (byte)4);
            cKeywords.add("null", (byte)4);
            cKeywords.add("super", (byte)4);
            cKeywords.add("true", (byte)4);
            cKeywords.add("false", (byte)4);
            cKeywords.add("$PPPQ", (byte)4);
            cKeywords.add("giulio", (byte)4);
        }
        return cKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }

    public void addKeyword(String key, byte id) {
        this.keywords.add(key, id);
    }
}

