/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.subdataset;

import it.businesslogic.ireport.SortField;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class SortFieldDialog
extends JDialog {
    private SortField tmpSortField = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxSortBy;
    private JComboBox jComboBoxSortType;
    private JLabel jLabelSortBy;
    private JLabel jLabelSortType;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private int dialogResult;

    public SortFieldDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jComboBoxSortBy.setEditable(true);
        this.applyI18n();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SortFieldDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.applyI18n();
        this.pack();
    }

    public void applyI18n() {
        this.setTitle(I18n.getString("sortFieldDialog.title", "Sort field"));
        this.jLabelSortBy.setText(I18n.getString("sortFieldDialog.labelSortBy", "Sort by..."));
        this.jLabelSortType.setText(I18n.getString("sortFieldDialog.labelSortType", "Sort type"));
        this.jComboBoxSortType.removeAllItems();
        this.jComboBoxSortType.addItem(new Tag("Ascending", I18n.getString("sortFieldDialog.Ascending", "Ascending")));
        this.jComboBoxSortType.addItem(new Tag("Descending", I18n.getString("sortFieldDialog.Descending", "Descending")));
        Misc.setComboboxSelectedTagValue(this.jComboBoxSortType, "Ascending");
        this.jButtonOK.setText(I18n.getString("ok", "Ok"));
        this.jButtonCancel.setText(I18n.getString("cancel", "Cancel"));
    }

    private void setFieldNames(Vector fields) {
        this.jComboBoxSortBy.removeAllItems();
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                this.jComboBoxSortBy.addItem(fields.get(i) + "");
            }
        }
    }

    private void initComponents() {
        this.jLabelSortBy = new JLabel();
        this.jComboBoxSortBy = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelSortType = new JLabel();
        this.jComboBoxSortType = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify parameter");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SortFieldDialog.this.closeDialog(evt);
            }
        });
        this.jLabelSortBy.setText("Sort by");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabelSortBy, gridBagConstraints);
        this.jComboBoxSortBy.setEditable(true);
        this.jComboBoxSortBy.setPreferredSize(new Dimension(250, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jComboBoxSortBy, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabelSortType.setText("Sort type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabelSortType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 8, 4);
        this.getContentPane().add((Component)this.jComboBoxSortType, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String fieldName = (String)this.jComboBoxSortBy.getSelectedItem();
        if (fieldName == null) {
            fieldName = "";
        }
        if ((fieldName = fieldName.trim()).length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("sortFieldDialog.messageNotValidField", "Please insert a valid field name!"), I18n.getString("sortFieldDialog.messageTitleNotValidField", "Invalid field!"), 2);
            return;
        }
        this.tmpSortField = new SortField(fieldName, this.jComboBoxSortType.getSelectedIndex() == 1);
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.setFieldNames(subDataset.getFields());
    }

    public SortField getSortField() {
        return this.tmpSortField;
    }

    public void setSortField(SortField tmpSortField) {
        this.tmpSortField = new SortField(tmpSortField);
        this.jComboBoxSortBy.setSelectedItem(tmpSortField.getFieldName());
        this.jComboBoxSortType.setSelectedIndex(tmpSortField.isDesc() ? 1 : 0);
    }
}

