/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.DocumentTreeEntry;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ProjectExplorerTreeCellRenderer
extends DefaultTreeCellRenderer {
    static ImageIcon folderClosedIcon;
    static ImageIcon folderOpenedIcon;
    static ImageIcon dirtyDocumentIcon;
    static ImageIcon documentIcon;

    public ProjectExplorerTreeCellRenderer() {
        if (folderClosedIcon == null) {
            folderClosedIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/folderClosed.gif"));
        }
        if (folderOpenedIcon == null) {
            folderOpenedIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/folderOpened.gif"));
        }
        if (dirtyDocumentIcon == null) {
            dirtyDocumentIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/docDirty.gif"));
        }
        if (documentIcon == null) {
            documentIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/doc.gif"));
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (!((DefaultMutableTreeNode)value).isRoot() && leaf && this.isDirty(value)) {
            this.setIcon(dirtyDocumentIcon);
            this.setToolTipText(null);
        } else if (!((DefaultMutableTreeNode)value).isRoot() && leaf && !this.isDirty(value)) {
            this.setIcon(documentIcon);
            this.setToolTipText(null);
        } else if ((((DefaultMutableTreeNode)value).isRoot() || !leaf) && expanded) {
            this.setIcon(folderOpenedIcon);
            this.setToolTipText(null);
        } else if (!(!((DefaultMutableTreeNode)value).isRoot() && leaf || expanded)) {
            this.setIcon(folderClosedIcon);
            this.setToolTipText(null);
        }
        return this;
    }

    protected boolean isDirty(Object value) {
        DocumentTreeEntry nodeInfo;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getUserObject() instanceof DocumentTreeEntry && (nodeInfo = (DocumentTreeEntry)node.getUserObject()).getJrf() != null) {
            return nodeInfo.getJrf().getReport().isModified();
        }
        return false;
    }
}

