/*
 * Decompiled with CFR 0.152.
 */
package ofc4j;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConverterMatcher;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import ofc4j.model.Chart;
import ofc4j.model.Text;
import ofc4j.model.axis.Axis;
import ofc4j.model.axis.Label;
import ofc4j.model.axis.XAxis;
import ofc4j.model.axis.XAxisLabels;
import ofc4j.model.axis.YAxis;
import ofc4j.model.elements.AreaHollowChart;
import ofc4j.model.elements.BarChart;
import ofc4j.model.elements.Element;
import ofc4j.model.elements.FilledBarChart;
import ofc4j.model.elements.HorizontalBarChart;
import ofc4j.model.elements.LineChart;
import ofc4j.model.elements.PieChart;
import ofc4j.model.elements.ScatterChart;
import ofc4j.model.elements.SketchBarChart;
import ofc4j.model.elements.StackedBarChart;
import ofc4j.model.metadata.Alias;
import ofc4j.model.metadata.Converter;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OFC {
    private static final Class<?>[] models = new Class[]{Chart.class, Axis.class, Text.class, XAxis.class, YAxis.class, XAxisLabels.class, Label.class, Element.class, Axis.class, BarChart.class, PieChart.class, HorizontalBarChart.class, LineChart.class, ScatterChart.class, AreaHollowChart.class, PieChart.Slice.class, HorizontalBarChart.Bar.class, Label.Rotation.class, ScatterChart.Point.class, FilledBarChart.class, SketchBarChart.class, StackedBarChart.class, StackedBarChart.StackValue.class, StackedBarChart.Stack.class, BarChart.Bar.class, FilledBarChart.Bar.class, SketchBarChart.Bar.class, LineChart.Dot.class};
    public static final OFC instance = new OFC();
    private final XStream converter = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());

    public OFC() {
        for (Class<?> c : models) {
            this.doAlias(c);
            this.doRegisterConverter(c);
        }
    }

    private void doAlias(Class<?> c) {
        if (c.isAnnotationPresent(Alias.class)) {
            this.converter.alias(c.getAnnotation(Alias.class).value(), c);
        }
        for (Field f : c.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Alias.class)) continue;
            this.converter.aliasField(f.getAnnotation(Alias.class).value(), c, f.getName());
        }
    }

    private void doRegisterConverter(Class<?> c) {
        if (c.isAnnotationPresent(Converter.class)) {
            Class<? extends ConverterMatcher> clazz = c.getAnnotation(Converter.class).value();
            try {
                if (SingleValueConverter.class.isAssignableFrom(clazz)) {
                    this.converter.registerConverter((SingleValueConverter)clazz.newInstance());
                } else {
                    this.converter.registerConverter((com.thoughtworks.xstream.converters.Converter)clazz.newInstance());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String render(Chart c) {
        String json = this.converter.toXML((Object)c);
        try {
            return new JSONObject(json).getString(Chart.class.getName());
        }
        catch (JSONException je) {
            System.err.println(json);
            je.printStackTrace();
            return null;
        }
    }

    public String prettyPrint(Chart c, int indentationLevel) {
        String json = this.converter.toXML((Object)c);
        try {
            return new JSONObject(json).getJSONObject(Chart.class.getName()).toString(indentationLevel);
        }
        catch (JSONException je) {
            System.err.println(json);
            je.printStackTrace();
            return null;
        }
    }

    public static <T> T[] toArray(Collection<T> collection, Class<? extends T> type) {
        return collection.toArray((Object[])Array.newInstance(type, collection.size()));
    }

    public static List<String> stringify(List<? extends Object> source) {
        ArrayList<String> strings = new ArrayList<String>(source.size());
        for (Object object : source) {
            strings.add(object.toString());
        }
        return strings;
    }

    public static String[] stringify(Object ... objects) {
        return OFC.stringify(Arrays.asList(objects)).toArray(new String[objects.length]);
    }
}

