/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.extensions;

import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.ClassUtils;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ExtensionsEnvironment {
    private static final Log log = LogFactory.getLog(ExtensionsEnvironment.class);
    protected static final Object NULL_CACHE_KEY = new Object();
    public static final String PROPERTY_EXTENSIONS_REGISTRY_CLASS = "net.sf.jasperreports.extensions.registry.class";
    private static ExtensionsRegistry systemRegistry;
    private static final ThreadLocal threadRegistry;

    private ExtensionsEnvironment() {
    }

    private static ExtensionsRegistry createDefaultRegistry() {
        String registryClass = JRProperties.getProperty(PROPERTY_EXTENSIONS_REGISTRY_CLASS);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Instantiating extensions registry class " + registryClass));
        }
        ExtensionsRegistry registry = (ExtensionsRegistry)ClassUtils.instantiateClass(registryClass, ExtensionsRegistry.class);
        return registry;
    }

    public static synchronized ExtensionsRegistry getSystemExtensionsRegistry() {
        return systemRegistry;
    }

    public static synchronized void setSystemExtensionsRegistry(ExtensionsRegistry extensionsRegistry) {
        if (extensionsRegistry == null) {
            throw new JRRuntimeException("Cannot set a null extensions registry.");
        }
        systemRegistry = extensionsRegistry;
    }

    public static ExtensionsRegistry getThreadExtensionsRegistry() {
        return (ExtensionsRegistry)threadRegistry.get();
    }

    public static void setThreadExtensionsRegistry(ExtensionsRegistry extensionsRegistry) {
        threadRegistry.set(extensionsRegistry);
    }

    public static void resetThreadExtensionsRegistry() {
        threadRegistry.set(null);
    }

    public static ExtensionsRegistry getExtensionsRegistry() {
        ExtensionsRegistry registry = ExtensionsEnvironment.getThreadExtensionsRegistry();
        if (registry == null) {
            registry = ExtensionsEnvironment.getSystemExtensionsRegistry();
        }
        return registry;
    }

    public static Object getExtensionsCacheKey() {
        Object key = Thread.currentThread().getContextClassLoader();
        if (key == null) {
            key = NULL_CACHE_KEY;
        }
        return key;
    }

    static {
        threadRegistry = new InheritableThreadLocal();
        systemRegistry = ExtensionsEnvironment.createDefaultRegistry();
    }
}

