/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sf.jasperreports.engine.JRRuntimeException;

public final class JRGraphEnvInitializer {
    private static Set AVAILABLE_FONT_FACE_NAMES;

    public static synchronized void initializeGraphEnv() {
        if (AVAILABLE_FONT_FACE_NAMES == null) {
            AVAILABLE_FONT_FACE_NAMES = new HashSet();
            try {
                AVAILABLE_FONT_FACE_NAMES.addAll(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
            }
            catch (Exception e) {
                throw new JRRuntimeException("Error initializing graphic environment.", e);
            }
        }
    }

    public static boolean isAwtFontAvailable(String font) {
        JRGraphEnvInitializer.initializeGraphEnv();
        return AVAILABLE_FONT_FACE_NAMES.contains(font);
    }

    private JRGraphEnvInitializer() {
    }
}

