/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.security.permission.PermissionCheckerBag;
import com.liferay.portal.service.PermissionService;
import com.liferay.portal.service.PermissionServiceFactory;
import java.rmi.RemoteException;

public class PermissionServiceUtil {
    public static void checkPermission(long groupId, String name, String primKey) throws PortalException, SystemException, RemoteException {
        PermissionService permissionService = PermissionServiceFactory.getService();
        permissionService.checkPermission(groupId, name, primKey);
    }

    public static boolean hasGroupPermission(long groupId, String actionId, long resourceId) throws PortalException, SystemException, RemoteException {
        PermissionService permissionService = PermissionServiceFactory.getService();
        return permissionService.hasGroupPermission(groupId, actionId, resourceId);
    }

    public static boolean hasUserPermission(long userId, String actionId, long resourceId) throws PortalException, SystemException, RemoteException {
        PermissionService permissionService = PermissionServiceFactory.getService();
        return permissionService.hasUserPermission(userId, actionId, resourceId);
    }

    public static boolean hasUserPermissions(long userId, long groupId, String actionId, long[] resourceIds, PermissionCheckerBag permissionCheckerBag) throws PortalException, SystemException, RemoteException {
        PermissionService permissionService = PermissionServiceFactory.getService();
        return permissionService.hasUserPermissions(userId, groupId, actionId, resourceIds, permissionCheckerBag);
    }

    public static void setGroupPermissions(long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException, RemoteException {
        PermissionService permissionService = PermissionServiceFactory.getService();
        permissionService.setGroupPermissions(groupId, actionIds, resourceId);
    }

    public static void setGroupPermissions(String className, String classPK, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException, RemoteException {
        PermissionService permissionService = PermissionServiceFactory.getService();
        permissionService.setGroupPermissions(className, classPK, groupId, actionIds, resourceId);
    }

    public static void setOrgGroupPermissions(long organizationId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException, RemoteException {
        PermissionService permissionService = PermissionServiceFactory.getService();
        permissionService.setOrgGroupPermissions(organizationId, groupId, actionIds, resourceId);
    }

    public static void setRolePermission(long roleId, long groupId, String name, int scope, String primKey, String actionId) throws PortalException, SystemException, RemoteException {
        PermissionService permissionService = PermissionServiceFactory.getService();
        permissionService.setRolePermission(roleId, groupId, name, scope, primKey, actionId);
    }

    public static void setUserPermissions(long userId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException, RemoteException {
        PermissionService permissionService = PermissionServiceFactory.getService();
        permissionService.setUserPermissions(userId, groupId, actionIds, resourceId);
    }

    public static void unsetRolePermission(long roleId, long groupId, long permissionId) throws PortalException, SystemException, RemoteException {
        PermissionService permissionService = PermissionServiceFactory.getService();
        permissionService.unsetRolePermission(roleId, groupId, permissionId);
    }

    public static void unsetRolePermission(long roleId, long groupId, String name, int scope, String primKey, String actionId) throws PortalException, SystemException, RemoteException {
        PermissionService permissionService = PermissionServiceFactory.getService();
        permissionService.unsetRolePermission(roleId, groupId, name, scope, primKey, actionId);
    }

    public static void unsetRolePermissions(long roleId, long groupId, String name, int scope, String actionId) throws PortalException, SystemException, RemoteException {
        PermissionService permissionService = PermissionServiceFactory.getService();
        permissionService.unsetRolePermissions(roleId, groupId, name, scope, actionId);
    }

    public static void unsetUserPermissions(long userId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException, RemoteException {
        PermissionService permissionService = PermissionServiceFactory.getService();
        permissionService.unsetUserPermissions(userId, groupId, actionIds, resourceId);
    }
}

