/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class RootWindow {
    public static final Integer DEFAULT_MAXED_LAYER = new Integer(JLayeredPane.PALETTE_LAYER - 10);
    private static final HashMap MAP_BY_ROOT_CONTAINER = new HashMap();
    private LayoutManager maxedLayout;
    private Integer maximizationLayer;
    private Component root;
    private HashMap clientProperties;

    private static Component getRoot(Component c) {
        Container parent;
        if (c == null) {
            return null;
        }
        if (RootWindow.isValidRootContainer(c)) {
            return c;
        }
        for (parent = c.getParent(); parent != null && !RootWindow.isValidRootContainer(parent); parent = parent.getParent()) {
        }
        return parent;
    }

    public static RootWindow getRootContainer(Component c) {
        Component root = RootWindow.getRoot(c);
        if (!RootWindow.isValidRootContainer(root)) {
            return null;
        }
        RootWindow container = (RootWindow)MAP_BY_ROOT_CONTAINER.get(root);
        if (container == null) {
            container = new RootWindow(root);
            MAP_BY_ROOT_CONTAINER.put(root, container);
        }
        if (container.getRootContainer() != root) {
            container.setRootContainer(root);
        }
        return container;
    }

    public static boolean isValidRootContainer(Component c) {
        return c != null && (c instanceof JFrame || c instanceof JApplet || c instanceof JWindow || c instanceof JDialog);
    }

    public static RootWindow[] getVisibleWindows() {
        Frame[] frames = Frame.getFrames();
        HashSet cache = new HashSet(frames.length);
        for (int i = 0; i < frames.length; ++i) {
            RootWindow.populateWindowList(new RootWindow(frames[i]), cache, true);
        }
        return cache.toArray(new RootWindow[0]);
    }

    private static void populateWindowList(RootWindow win, HashSet winCache, boolean visOnly) {
        if (win == null || winCache.contains(win)) {
            return;
        }
        if (visOnly && !win.getRootContainer().isVisible()) {
            return;
        }
        winCache.add(win);
        Window[] children = win.getOwnedWindows();
        for (int i = 0; i < children.length; ++i) {
            RootWindow.populateWindowList(new RootWindow(children[i]), winCache, visOnly);
        }
    }

    protected RootWindow(Component root) {
        this.setMaximizationLayer(DEFAULT_MAXED_LAYER);
        this.setRootContainer(root);
        this.clientProperties = new HashMap();
    }

    public Container getContentPane() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getContentPane();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getContentPane();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getContentPane();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getContentPane();
        }
        return null;
    }

    public Component getGlassPane() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getGlassPane();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getGlassPane();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getGlassPane();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getGlassPane();
        }
        return null;
    }

    public JLayeredPane getLayeredPane() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getLayeredPane();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getLayeredPane();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getLayeredPane();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getLayeredPane();
        }
        return null;
    }

    public Point getLocationOnScreen() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getLocationOnScreen();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getLocationOnScreen();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getLocationOnScreen();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getLocationOnScreen();
        }
        return null;
    }

    public Integer getMaximizationLayer() {
        return this.maximizationLayer;
    }

    public LayoutManager getMaximizedLayout() {
        return this.maxedLayout;
    }

    public Component getRootContainer() {
        return this.root;
    }

    public JRootPane getRootPane() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getRootPane();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getRootPane();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getRootPane();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getRootPane();
        }
        return null;
    }

    public void revalidateContentPane() {
        Container c = this.getContentPane();
        if (c instanceof JComponent) {
            ((JComponent)c).revalidate();
        }
    }

    public void setContentPane(Container contentPane) {
        if (this.root instanceof JFrame) {
            ((JFrame)this.root).setContentPane(contentPane);
        } else if (this.root instanceof JApplet) {
            ((JApplet)this.root).setContentPane(contentPane);
        } else if (this.root instanceof JWindow) {
            ((JWindow)this.root).setContentPane(contentPane);
        } else if (this.root instanceof JDialog) {
            ((JDialog)this.root).setContentPane(contentPane);
        }
    }

    public void setGlassPane(Component glassPane) {
        if (this.root instanceof JFrame) {
            ((JFrame)this.root).setGlassPane(glassPane);
        } else if (this.root instanceof JApplet) {
            ((JApplet)this.root).setGlassPane(glassPane);
        } else if (this.root instanceof JWindow) {
            ((JWindow)this.root).setGlassPane(glassPane);
        } else if (this.root instanceof JDialog) {
            ((JDialog)this.root).setGlassPane(glassPane);
        }
    }

    public void setLayeredPane(JLayeredPane layeredPane) {
        if (this.root instanceof JFrame) {
            ((JFrame)this.root).setLayeredPane(layeredPane);
        } else if (this.root instanceof JApplet) {
            ((JApplet)this.root).setLayeredPane(layeredPane);
        } else if (this.root instanceof JWindow) {
            ((JWindow)this.root).setLayeredPane(layeredPane);
        } else if (this.root instanceof JDialog) {
            ((JDialog)this.root).setLayeredPane(layeredPane);
        }
    }

    public Window[] getOwnedWindows() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getOwnedWindows();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getOwnedWindows();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getOwnedWindows();
        }
        return new Window[0];
    }

    public void setMaximizationLayer(Integer layer) {
        if (layer == null) {
            layer = DEFAULT_MAXED_LAYER;
        }
        this.maximizationLayer = layer;
    }

    public void setMaximizedLayout(LayoutManager mgr) {
        this.maxedLayout = mgr;
    }

    protected void setRootContainer(Component root) {
        this.root = root;
    }

    public void updateComponentTreeUI() {
        SwingUtilities.updateComponentTreeUI(this.root);
        this.pack();
    }

    public void pack() {
        if (this.root instanceof JFrame) {
            ((JFrame)this.root).pack();
        } else if (this.root instanceof JWindow) {
            ((JWindow)this.root).pack();
        } else if (this.root instanceof JDialog) {
            ((JDialog)this.root).pack();
        }
    }

    public void toFront() {
        if (this.root instanceof JFrame) {
            ((JFrame)this.root).toFront();
        } else if (this.root instanceof JWindow) {
            ((JWindow)this.root).toFront();
        } else if (this.root instanceof JDialog) {
            ((JDialog)this.root).toFront();
        }
    }

    public boolean isActive() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).isActive();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).isActive();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).isActive();
        }
        return false;
    }

    public Window getOwner() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getOwner();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getOwner();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getOwner();
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getBounds();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getBounds();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getBounds();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getBounds();
        }
        return null;
    }

    public void putClientProperty(Object key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.clientProperties.remove(key);
        } else {
            this.clientProperties.put(key, value);
        }
    }

    public Object getClientProperty(Object key) {
        return key == null ? null : this.clientProperties.get(key);
    }
}

