/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.plaf;

import java.util.HashMap;
import org.flexdock.plaf.PropertySet;
import org.flexdock.plaf.XMLConstants;
import org.flexdock.plaf.resources.ResourceHandler;
import org.flexdock.plaf.resources.ResourceHandlerFactory;
import org.flexdock.util.ResourceManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Configurator
implements XMLConstants {
    public static final String DEFAULT_PREFS_URI = "org/flexdock/plaf/flexdock-themes-default.xml";
    public static final String PREFS_URI = "flexdock-themes.xml";

    public static Document loadUserPrefs() {
        return ResourceManager.getDocument(PREFS_URI);
    }

    public static Document loadDefaultPrefs() {
        return ResourceManager.getDocument(DEFAULT_PREFS_URI);
    }

    public static HashMap getNamedElementsByTagName(String tagName) {
        if (Configurator.isNull(tagName)) {
            return null;
        }
        HashMap cache = new HashMap(256);
        Document defaults = Configurator.loadDefaultPrefs();
        Configurator.loadNamedElementsByTagName(defaults, tagName, cache);
        Document user = Configurator.loadUserPrefs();
        Configurator.loadNamedElementsByTagName(user, tagName, cache);
        return cache;
    }

    private static void loadNamedElementsByTagName(Document document, String tagName, HashMap cache) {
        if (document == null) {
            return;
        }
        NodeList elements = document.getElementsByTagName(tagName);
        for (int i = 0; i < elements.getLength(); ++i) {
            Element oldValue;
            Element elem = (Element)elements.item(i);
            String key = elem.getAttribute("name");
            boolean inherit = "true".equals(elem.getAttribute("inherits"));
            if (Configurator.isNull(key)) continue;
            if (inherit && (oldValue = (Element)cache.get(key)) != null) {
                cache.put("flexview.element.overridden." + key, oldValue);
            }
            cache.put(key, elem);
        }
    }

    public static PropertySet[] getProperties(String tagName) {
        HashMap map = Configurator.getNamedElementsByTagName(tagName);
        if (map == null) {
            return new PropertySet[0];
        }
        String[] names = map.keySet().toArray(new String[0]);
        return Configurator.getProperties(names, map);
    }

    public static PropertySet getProperties(String name, String tagName) {
        HashMap map = Configurator.getNamedElementsByTagName(tagName);
        if (map == null) {
            return null;
        }
        return Configurator.getProperties(name, map);
    }

    public static PropertySet[] getProperties(String[] names, String tagName) {
        HashMap map;
        HashMap hashMap = map = names == null ? null : Configurator.getNamedElementsByTagName(tagName);
        if (map == null) {
            return new PropertySet[0];
        }
        return Configurator.getProperties(names, map);
    }

    public static PropertySet[] getProperties(String[] names, HashMap cache) {
        PropertySet[] properties = new PropertySet[names.length];
        for (int i = 0; i < names.length; ++i) {
            properties[i] = Configurator.getProperties(names[i], cache);
        }
        return properties;
    }

    private static PropertySet getProperties(String elemName, HashMap cache) {
        PropertySet overridden;
        PropertySet parent;
        Element elem;
        Element element = elem = Configurator.isNull(elemName) ? null : (Element)cache.get(elemName);
        if (elem == null) {
            return null;
        }
        PropertySet set = new PropertySet();
        set.setName(elemName);
        String parentName = elem.getAttribute("extends");
        PropertySet propertySet = parent = Configurator.isNull(parentName) ? null : Configurator.getProperties(parentName, cache);
        if (parent != null) {
            set.setAll(parent);
        }
        if ("true".equalsIgnoreCase(elem.getAttribute("inherits")) && (overridden = Configurator.getProperties("flexview.element.overridden." + elemName, cache)) != null) {
            set.setAll(overridden);
        }
        String propertyHandlerName = Configurator.getPropertyHandlerName(elem);
        NodeList list = elem.getElementsByTagName("property");
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            String handler;
            String value;
            Object resource;
            elem = (Element)list.item(i);
            String key = elem.getAttribute("name");
            if (Configurator.isNull(key) || (resource = Configurator.getResource(value = elem.getAttribute("value"), handler = elem.getAttribute("handler"), propertyHandlerName)) == null) continue;
            set.setProperty(key, resource);
        }
        return set;
    }

    private static String getPropertyHandlerName(Element elem) {
        String handlerName = elem.getAttribute("prop-handler");
        if (Configurator.isNull(handlerName)) {
            handlerName = ResourceHandlerFactory.getPropertyHandler(elem.getTagName());
        }
        return Configurator.isNull(handlerName) ? null : handlerName;
    }

    public static Object getResource(String stringValue, String currentHandlerName, String defaultHandlerName) {
        String handlerName;
        String string = handlerName = Configurator.isNull(currentHandlerName) ? defaultHandlerName : currentHandlerName;
        if (Configurator.isNull(handlerName)) {
            return Configurator.nullify(stringValue);
        }
        ResourceHandler handler = ResourceHandlerFactory.getResourceHandler(handlerName);
        return handler == null ? Configurator.nullify(stringValue) : handler.getResource(stringValue);
    }

    private static String nullify(String data) {
        return Configurator.isNull(data) ? null : data;
    }

    public static boolean isNull(String data) {
        data = data == null ? null : data.trim();
        return data == null || data.length() == 0;
    }
}

