/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.irplugin;

import com.jaspersoft.jasperserver.irplugin.gui.JRPluginConfigurationDialog;
import it.businesslogic.ireport.plugin.IReportPlugin;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URLConnection;

/**
 *
 * @author  Administrator
 */
public class UpgradeSearch implements Runnable {
    
    private JRPluginConfigurationDialog win = null;
    public void run() {
        
        if (! IRPlugin.getMainInstance().getBrandingProperties().getProperty("irplugin.update.checking.enabled", "true").equals("true"))
        {
            // Update checking disabled...
            return;
        }
        
        try {
            
            IRPlugin.getMainInstance().applyProxySettings();
            
            java.net.URL url = new java.net.URL(IRPlugin.getMainInstance().getBrandingProperties().getProperty("irplugin.update.url"));
            
            URLConnection uConn = url.openConnection();
            
            java.util.Properties props = IRPlugin.getMainInstance().getProperties();
        
            
            if (props.getProperty(IRPlugin.PROPERTY_USE_PROXY, "false").equals("true") &&
                props.getProperty(IRPlugin.PROPERTY_PROXY_USE_AUTH, "false").equals("true"))
            {
                String password = props.getProperty(IRPlugin.PROPERTY_PROXY_USERNAME, "") + ":" + props.getProperty(IRPlugin.PROPERTY_PROXY_PASSWORD, "");
                
                org.w3c.tools.codec.Base64Encoder b = new org.w3c.tools.codec.Base64Encoder(password);
		String encodedPassword = b.processString();
                uConn.setRequestProperty( "Proxy-Authorization", encodedPassword );
            }
            
            
            //uConn.setReadTimeout(1000);
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(uConn.getInputStream()));
            String version = null;
            while ((version = lnr.readLine() ) != null)
            {
                //IRPlugin.getMainInstance().getMainFrame().logOnConsole("v? " +version);
        
                if (version.startsWith("JasperIntelligence ")) {
                    String vnumber = version.substring( "JasperIntelligence ".length());
                    
                    //IRPlugin.getMainInstance().getMainFrame().logOnConsole("Remote: " + vnumber + " local: " + IRPlugin.CURRENT_VERSION+ " (" + vnumber.compareTo(IRPlugin.CURRENT_VERSION) + ")");
                    
                    if (vnumber.compareTo(IRPlugin.CURRENT_VERSION) > 0) {

                        final String fversion = "" + vnumber;
                        javax.swing.SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            javax.swing.JOptionPane.showMessageDialog(it.businesslogic.ireport.gui.MainFrame.getMainInstance(),
                                    IRPlugin.getFormattedString("messages.newversion", "{0} is available on http://www.jasperforge.org!", 
                                               new Object[] {fversion}));
                        }});
                    }
                }
            }
            
        } catch (Throwable ex) {
            ex.printStackTrace();
        }
        
        if (win != null)   win.setVisible(false);
    }

    public JRPluginConfigurationDialog getWin() {
        return win;
    }

    public void setWin(JRPluginConfigurationDialog win) {
        this.win = win;
    }
}

