/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.irplugin;

import com.jaspersoft.jasperserver.irplugin.gui.RepositoryExplorer;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.flexdock.docking.DockingConstants;
import org.flexdock.view.View;

/**
 *
 * @author gtoffoli
 */
public class DockingUtil {
    
    public static View view = null;
    
    public static void installUI(RepositoryExplorer explorer)
    {
        if (view == null)
        {
            // Get the title from the branding properties...
            String title = "JasperServer";
            title = IRPlugin.getMainInstance().getBrandingProperties().getProperty("irplugin.title");
            String version = IRPlugin.getMainInstance().getBrandingProperties().getProperty("irplugin.version");
            
            java.text.MessageFormat mf = new java.text.MessageFormat(title, I18n.getCurrentLocale());
            title =  mf.format(new Object[]{version});
            
            view = createView("JasperServer",
                              title,
                              true, true, explorer);
            
            
        }
 
        boolean visible = false;
        if (!MainFrame.getMainInstance().getDesktopView().dock(view, DockingConstants.WEST_REGION, 0.3f))
        {
            visible = Misc.dockAt( view, DockingConstants.WEST_REGION, 0);
        }
        else
        {
            visible = true;
            org.flexdock.docking.DockingManager.setSplitProportion(view.getComponent(), 0.3f);
        }
        
        IRPlugin.getMainInstance().setViewVisible(visible );
    }
    
    /*
     *
     *
     */
    public static View createView(String id, String text, boolean closable, boolean pin, Component c) {
		
                View view = new View(id, text);
                
		if (closable)
                {
                    view.getTitlebar().addAction(DockingConstants.CLOSE_ACTION);
                    if ( view.getTitlebar().getActionButton(DockingConstants.CLOSE_ACTION) != null)
                    {
                        view.getTitlebar().getActionButton(DockingConstants.CLOSE_ACTION).addActionListener(
                        new ActionListener()
			{
				public void actionPerformed(ActionEvent e) 
				{
					View viewx = (View)javax.swing.SwingUtilities.getAncestorOfClass(View.class, (java.awt.Component)e.getSource());
			    		IRPlugin.getMainInstance().setViewVisible(false);
				}
			}
                    );
                    }
                }
		if (pin) view.addAction(DockingConstants.PIN_ACTION);

                
                 
		JPanel p = new JPanel();
		//		p.setBackground(Color.WHITE);
                p.setLayout(new BorderLayout());
		p.setBorder(new LineBorder(java.awt.Color.GRAY, 1));

		
		p.add(c, BorderLayout.CENTER);

		view.setContentPane(p);
		return view;
                
	}
    
}
