/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.export.modules.auth.beans;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.export.modules.auth.AuthorityImportHandler;
import com.jaspersoft.jasperserver.export.modules.common.ProfileAttributeBean;
import com.jaspersoft.jasperserver.export.modules.common.TenantQualifiedName;
import com.jaspersoft.jasperserver.export.util.CommandOut;

/**
 * @author tkavanagh
 * @version $Id: UserBean.java 19925 2010-12-11 15:06:41Z tmatyashovsky $
 */
public class UserBean {
	
	private static final CommandOut commandOut = CommandOut.getInstance();
	
	private String username;
	private String fullName;
	private String password;
	private String emailAddress;
	private boolean externallyDefined = false;
	private boolean enabled = false;
	private TenantQualifiedName[] roleNames;
	private ProfileAttributeBean[] attributes;
	private Date previousPasswordChangeTime;
	private String tenantId;

	public void copyFrom(User user) {
		setUsername(user.getUsername());
		setFullName(user.getFullName());
		setPassword(user.getPassword());
		setEmailAddress(user.getEmailAddress());
		setExternallyDefined(user.isExternallyDefined());
		setEnabled(user.isEnabled());
		setPreviousPasswordChangeTime(user.getPreviousPasswordChangeTime());
		setTenantId(user.getTenantId());
		copyRolesFrom(user);
		copyAttributesFrom(user);
	}

	protected void copyRolesFrom(User user) {
		Set roles = user.getRoles();
		TenantQualifiedName[] names;
		if (roles != null && !roles.isEmpty()) {
			names = new TenantQualifiedName[roles.size()];
			int c = 0;
			for (Iterator iter = roles.iterator(); iter.hasNext(); ++c) {
				Role role = (Role) iter.next();
				names[c] = new TenantQualifiedName(
						role.getTenantId(), role.getRoleName());
			}
		} else {
			names = null;
		}
		setRoleNames(names);
	}

	public void copyAttributesFrom(User user) {
		List userAttributes = user.getAttributes();
		if (userAttributes == null || userAttributes.isEmpty()) {
			attributes = null;
		} else {
			attributes = new ProfileAttributeBean[userAttributes.size()];
			int idx = 0;
			for (Iterator it = userAttributes.iterator(); it
					.hasNext(); ++idx) {
				ProfileAttribute attr = (ProfileAttribute) it.next();
				attributes[idx] = new ProfileAttributeBean();
				attributes[idx].copyFrom(attr);
			}
		}
	}

	public void copyTo(User user, AuthorityImportHandler importHandler) {
		user.setUsername(getUsername());
		user.setFullName(getFullName());
		user.setPassword(getPassword());
		user.setEmailAddress(getEmailAddress());
		user.setExternallyDefined(isExternallyDefined());
		user.setEnabled(isEnabled());
		user.setPreviousPasswordChangeTime(getPreviousPasswordChangeTime());
		user.setTenantId(getTenantId());

		copyRolesTo(user, importHandler);
	}
	
	protected void copyRolesTo(User user, AuthorityImportHandler importHandler) {
		Set roles;
		if (roleNames == null) {
			roles = null;
		} else {
			roles = new HashSet();
			for (int i = 0; i < roleNames.length; i++) {
				TenantQualifiedName roleName = roleNames[i];
				Role role = importHandler.resolveRole(roleName);
				if (role == null) {
					commandOut.warn("Role " + roleName.getName()
							+ (roleName.getTenantId() == null ? "" : (" of tenant " + roleName.getTenantId()))
							+ " not found while copying user " + getUsername() + ", skipping.");
				} else {
					roles.add(role);
				}
			}
		}
		user.setRoles(roles);
	}

	public String getEmailAddress() {
		return emailAddress;
	}
	
	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}
	
	public boolean isEnabled() {
		return enabled;
	}
	
	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}
	
	public boolean isExternallyDefined() {
		return externallyDefined;
	}
	
	public void setExternallyDefined(boolean externallyDefined) {
		this.externallyDefined = externallyDefined;
	}
	
	public String getFullName() {
		return fullName;
	}
	
	public void setFullName(String fullName) {
		this.fullName = fullName;
	}
	
	public String getPassword() {
		return password;
	}
	
	public void setPassword(String password) {
		this.password = password;
	}
	
	public String getUsername() {
		return username;
	}
	
	public void setUsername(String username) {
		this.username = username;
	}

	public TenantQualifiedName[] getRoleNames() {
		return roleNames;
	}

	public void setRoleNames(TenantQualifiedName[] roleNames) {
		this.roleNames = roleNames;
	}

	public ProfileAttributeBean[] getAttributes() {
		return attributes;
	}

	public void setAttributes(ProfileAttributeBean[] attributes) {
		this.attributes = attributes;
	}

	public Date getPreviousPasswordChangeTime() {
		return previousPasswordChangeTime;
	}

	public void setPreviousPasswordChangeTime(Date previousPasswordChangeTime) {
		this.previousPasswordChangeTime = previousPasswordChangeTime;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	
}
