/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.utils.DBConnectionManager;

public class JobStoreCMT
extends JobStoreSupport {
    protected String nonManagedTxDsName;
    protected boolean dontSetNonManagedTXConnectionAutoCommitFalse = false;
    protected boolean setTxIsolationLevelReadCommitted = false;

    public void setNonManagedTXDataSource(String nonManagedTxDsName) {
        this.nonManagedTxDsName = nonManagedTxDsName;
    }

    public String getNonManagedTXDataSource() {
        return this.nonManagedTxDsName;
    }

    public boolean isDontSetNonManagedTXConnectionAutoCommitFalse() {
        return this.dontSetNonManagedTXConnectionAutoCommitFalse;
    }

    public void setDontSetNonManagedTXConnectionAutoCommitFalse(boolean b) {
        this.dontSetNonManagedTXConnectionAutoCommitFalse = b;
    }

    public boolean isTxIsolationLevelReadCommitted() {
        return this.setTxIsolationLevelReadCommitted;
    }

    public void setTxIsolationLevelReadCommitted(boolean b) {
        this.setTxIsolationLevelReadCommitted = b;
    }

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        if (this.nonManagedTxDsName == null) {
            throw new SchedulerConfigException("Non-ManagedTX DataSource name not set!");
        }
        this.setUseDBLocks(true);
        super.initialize(loadHelper, signaler);
        this.getLog().info((Object)"JobStoreCMT initialized.");
    }

    public void shutdown() {
        super.shutdown();
        try {
            DBConnectionManager.getInstance().shutdown(this.getNonManagedTXDataSource());
        }
        catch (SQLException sqle) {
            this.getLog().warn((Object)"Database connection shutdown unsuccessful.", (Throwable)sqle);
        }
    }

    protected void recoverJobs() throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        try {
            conn = this.getNonManagedTXConnection();
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.recoverJobs(conn);
            conn.commit();
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        catch (Exception e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("Error recovering jobs: " + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                this.closeConnection(conn);
            }
        }
    }

    protected void cleanVolatileTriggerAndJobs() throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        try {
            conn = this.getNonManagedTXConnection();
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.cleanVolatileTriggerAndJobs(conn);
            conn.commit();
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        catch (Exception e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("Error cleaning volatile data: " + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                this.closeConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJobAndTrigger(SchedulingContext ctxt, JobDetail newJob, Trigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            if (this.isLockOnInsert()) {
                this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
                transOwner = true;
            }
            if (newJob.isVolatile() && !newTrigger.isVolatile()) {
                JobPersistenceException jpe = new JobPersistenceException("Cannot associate non-volatile trigger with a volatile job!");
                jpe.setErrorCode(100);
                throw jpe;
            }
            this.storeJob(conn, ctxt, newJob, false);
            this.storeTrigger(conn, ctxt, newTrigger, newJob, false, "WAITING", false, false);
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJob(SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            if (this.isLockOnInsert() || replaceExisting) {
                this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
                transOwner = true;
            }
            this.storeJob(conn, ctxt, newJob, replaceExisting);
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            boolean bl = this.removeJob(conn, ctxt, jobName, groupName, true);
            return bl;
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobDetail retrieveJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            JobDetail jobDetail = this.retrieveJob(conn, ctxt, jobName, groupName);
            return jobDetail;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTrigger(SchedulingContext ctxt, Trigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            if (this.isLockOnInsert() || replaceExisting) {
                this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
                transOwner = true;
            }
            this.storeTrigger(conn, ctxt, newTrigger, null, replaceExisting, "WAITING", false, false);
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            boolean bl = this.removeTrigger(conn, ctxt, triggerName, groupName);
            return bl;
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceTrigger(SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            boolean bl = this.replaceTrigger(conn, ctxt, triggerName, groupName, newTrigger);
            return bl;
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger retrieveTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            Trigger trigger = this.retrieveTrigger(conn, ctxt, triggerName, groupName);
            return trigger;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCalendar(SchedulingContext ctxt, String calName, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean lockOwner = false;
        try {
            if (this.isLockOnInsert() || updateTriggers) {
                this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
                lockOwner = true;
            }
            this.storeCalendar(conn, ctxt, calName, calendar, replaceExisting, updateTriggers);
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, lockOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, LOCK_CALENDAR_ACCESS);
            boolean bl = this.removeCalendar(conn, ctxt, calName);
            return bl;
        }
        finally {
            this.releaseLock(conn, LOCK_CALENDAR_ACCESS, true);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar retrieveCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            Calendar calendar = this.retrieveCalendar(conn, ctxt, calName);
            return calendar;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfJobs(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int n = this.getNumberOfJobs(conn, ctxt);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfTriggers(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int n = this.getNumberOfTriggers(conn, ctxt);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCalendars(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int n = this.getNumberOfCalendars(conn, ctxt);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPausedTriggerGroups(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            Set groups;
            Set set = groups = this.getPausedTriggerGroups(conn, ctxt);
            return set;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getJobNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] stringArray = this.getJobNames(conn, ctxt, groupName);
            return stringArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTriggerNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] stringArray = this.getTriggerNames(conn, ctxt, groupName);
            return stringArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getJobGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] stringArray = this.getJobGroupNames(conn, ctxt);
            return stringArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTriggerGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] stringArray = this.getTriggerGroupNames(conn, ctxt);
            return stringArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCalendarNames(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] stringArray = this.getCalendarNames(conn, ctxt);
            return stringArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger[] getTriggersForJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            Trigger[] triggerArray = this.getTriggersForJob(conn, ctxt, jobName, groupName);
            return triggerArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTriggerState(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int n = this.getTriggerState(conn, ctxt, triggerName, groupName);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.pauseTrigger(conn, ctxt, triggerName, groupName);
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.pauseTriggerGroup(conn, ctxt, groupName);
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobName, groupName);
            for (int j = 0; j < triggers.length; ++j) {
                this.pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
            }
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            String[] jobNames = this.getJobNames(conn, ctxt, groupName);
            for (int i = 0; i < jobNames.length; ++i) {
                Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobNames[i], groupName);
                for (int j = 0; j < triggers.length; ++j) {
                    this.pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                }
            }
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.resumeTrigger(conn, ctxt, triggerName, groupName);
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.resumeTriggerGroup(conn, ctxt, groupName);
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobName, groupName);
            for (int j = 0; j < triggers.length; ++j) {
                this.resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
            }
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            String[] jobNames = this.getJobNames(conn, ctxt, groupName);
            for (int i = 0; i < jobNames.length; ++i) {
                Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobNames[i], groupName);
                for (int j = 0; j < triggers.length; ++j) {
                    this.resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                }
            }
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAll(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.pauseAll(conn, ctxt);
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAll(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.resumeAll(conn, ctxt);
        }
        finally {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
        }
    }

    public Trigger acquireNextTrigger(SchedulingContext ctxt, long noLaterThan) throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        try {
            conn = this.getNonManagedTXConnection();
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            Trigger trigger = this.acquireNextTrigger(conn, ctxt, noLaterThan);
            conn.commit();
            Trigger trigger2 = trigger;
            return trigger2;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        catch (Exception e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("Error acquiring next firable trigger: " + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                this.closeConnection(conn);
            }
        }
    }

    public void releaseAcquiredTrigger(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        try {
            conn = this.getNonManagedTXConnection();
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.releaseAcquiredTrigger(conn, ctxt, trigger);
            conn.commit();
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        catch (Exception e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("Error releasing acquired trigger: " + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                this.closeConnection(conn);
            }
        }
    }

    public TriggerFiredBundle triggerFired(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        try {
            conn = this.getNonManagedTXConnection();
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            TriggerFiredBundle tfb = null;
            JobPersistenceException err = null;
            try {
                tfb = this.triggerFired(conn, ctxt, trigger);
            }
            catch (JobPersistenceException jpe) {
                if (jpe.getErrorCode() != 410) {
                    throw jpe;
                }
                err = jpe;
            }
            if (err != null) {
                throw err;
            }
            conn.commit();
            TriggerFiredBundle triggerFiredBundle = tfb;
            return triggerFiredBundle;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        catch (Exception e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                this.closeConnection(conn);
            }
        }
    }

    public void triggeredJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode) throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        try {
            conn = this.getNonManagedTXConnection();
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.triggeredJobComplete(conn, ctxt, trigger, jobDetail, triggerInstCode);
            conn.commit();
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        catch (Exception e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                this.closeConnection(conn);
            }
        }
    }

    protected boolean doRecoverMisfires() throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        boolean moreToDo = false;
        try {
            conn = this.getNonManagedTXConnection();
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            try {
                moreToDo = this.recoverMisfiredJobs(conn, false);
            }
            catch (Exception e) {
                throw new JobPersistenceException(e.getMessage(), e);
            }
            conn.commit();
            boolean e = moreToDo;
            return e;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        catch (Exception e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                this.closeConnection(conn);
            }
        }
    }

    protected boolean doCheckin() throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        boolean transStateOwner = false;
        boolean recovered = false;
        try {
            conn = this.getNonManagedTXConnection();
            this.getLockHandler().obtainLock(conn, LOCK_STATE_ACCESS);
            transStateOwner = true;
            List failedRecords = this.clusterCheckIn(conn);
            if (failedRecords.size() > 0) {
                this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.clusterRecover(conn, failedRecords);
                recovered = true;
            }
            conn.commit();
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        catch (Exception e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                this.releaseLock(conn, LOCK_STATE_ACCESS, transStateOwner);
                this.closeConnection(conn);
            }
        }
        this.firstCheckIn = false;
        return recovered;
    }

    protected Connection getNonManagedTXConnection() throws JobPersistenceException {
        try {
            Connection conn = DBConnectionManager.getInstance().getConnection(this.getNonManagedTXDataSource());
            if (conn == null) {
                throw new SQLException("Could not get connection from DataSource '" + this.getNonManagedTXDataSource() + "'");
            }
            if (!this.isDontSetNonManagedTXConnectionAutoCommitFalse()) {
                conn.setAutoCommit(false);
            }
            if (this.isTxIsolationLevelReadCommitted()) {
                conn.setTransactionIsolation(1);
            }
            return conn;
        }
        catch (SQLException sqle) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getNonManagedTXDataSource() + "': " + sqle.toString(), sqle);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getNonManagedTXDataSource() + "': " + e.toString(), e, 499);
        }
    }
}

