/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.vote;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.vote.AffirmativeBased;
import org.springframework.security.vote.DenyAgainVoter;
import org.springframework.security.vote.DenyVoter;
import org.springframework.security.vote.RoleVoter;

public class AffirmativeBasedTests
extends TestCase {
    public AffirmativeBasedTests() {
    }

    public AffirmativeBasedTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(AffirmativeBasedTests.class);
    }

    private AffirmativeBased makeDecisionManager() {
        AffirmativeBased decisionManager = new AffirmativeBased();
        RoleVoter roleVoter = new RoleVoter();
        DenyVoter denyForSureVoter = new DenyVoter();
        DenyAgainVoter denyAgainForSureVoter = new DenyAgainVoter();
        Vector<Object> voters = new Vector<Object>();
        voters.add(roleVoter);
        voters.add(denyForSureVoter);
        voters.add(denyAgainForSureVoter);
        decisionManager.setDecisionVoters(voters);
        return decisionManager;
    }

    private TestingAuthenticationToken makeTestToken() {
        return new TestingAuthenticationToken((Object)"somebody", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_1"), new GrantedAuthorityImpl("ROLE_2")});
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testOneAffirmativeVoteOneDenyVoteOneAbstainVoteGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition(new String[]{"ROLE_1", "DENY_FOR_SURE"});
        mgr.decide((Authentication)auth, new Object(), config);
        AffirmativeBasedTests.assertTrue((boolean)true);
    }

    public void testOneAffirmativeVoteTwoAbstainVotesGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition("ROLE_2");
        mgr.decide((Authentication)auth, new Object(), config);
        AffirmativeBasedTests.assertTrue((boolean)true);
    }

    public void testOneDenyVoteTwoAbstainVotesDeniesAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition("ROLE_WE_DO_NOT_HAVE");
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            AffirmativeBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            AffirmativeBasedTests.assertTrue((boolean)true);
        }
    }

    public void testThreeAbstainVotesDeniesAccessWithDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        AffirmativeBasedTests.assertTrue((!mgr.isAllowIfAllAbstainDecisions() ? 1 : 0) != 0);
        ConfigAttributeDefinition config = new ConfigAttributeDefinition("IGNORED_BY_ALL");
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            AffirmativeBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            AffirmativeBasedTests.assertTrue((boolean)true);
        }
    }

    public void testThreeAbstainVotesGrantsAccessWithoutDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        mgr.setAllowIfAllAbstainDecisions(true);
        AffirmativeBasedTests.assertTrue((boolean)mgr.isAllowIfAllAbstainDecisions());
        ConfigAttributeDefinition config = new ConfigAttributeDefinition("IGNORED_BY_ALL");
        mgr.decide((Authentication)auth, new Object(), config);
        AffirmativeBasedTests.assertTrue((boolean)true);
    }

    public void testTwoAffirmativeVotesTwoAbstainVotesGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition(new String[]{"ROLE_1", "ROLE_2"});
        mgr.decide((Authentication)auth, new Object(), config);
        AffirmativeBasedTests.assertTrue((boolean)true);
    }
}

