/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.MockFilterConfig;
import org.springframework.security.context.HttpSessionContextIntegrationFilter;
import org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.FilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.MockFilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.RequestKey;
import org.springframework.security.ui.webapp.AuthenticationProcessingFilter;
import org.springframework.security.util.AntUrlPathMatcher;
import org.springframework.security.util.FilterChainProxy;
import org.springframework.security.util.MockFilter;
import org.springframework.security.util.MockFilterChain;
import org.springframework.security.util.UrlMatcher;

public class FilterChainProxyTests {
    private ClassPathXmlApplicationContext appCtx;

    @Before
    public void loadContext() {
        this.appCtx = new ClassPathXmlApplicationContext("org/springframework/security/util/filtertest-valid.xml");
    }

    @After
    public void closeContext() {
        if (this.appCtx != null) {
            this.appCtx.close();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDetectsFilterInvocationDefinitionSourceThatDoesNotReturnAllConfigAttributes() throws Exception {
        FilterChainProxy filterChainProxy = new FilterChainProxy();
        filterChainProxy.setApplicationContext((ApplicationContext)new StaticApplicationContext());
        filterChainProxy.setFilterInvocationDefinitionSource((FilterInvocationDefinitionSource)new MockFilterInvocationDefinitionSource(false, false));
        filterChainProxy.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDetectsIfConfigAttributeDoesNotReturnValueForGetAttributeMethod() throws Exception {
        FilterChainProxy filterChainProxy = new FilterChainProxy();
        filterChainProxy.setApplicationContext((ApplicationContext)new StaticApplicationContext());
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition((ConfigAttribute)new MockConfigAttribute());
        LinkedHashMap<RequestKey, ConfigAttributeDefinition> map = new LinkedHashMap<RequestKey, ConfigAttributeDefinition>();
        map.put(new RequestKey("/**"), cad);
        DefaultFilterInvocationDefinitionSource fids = new DefaultFilterInvocationDefinitionSource((UrlMatcher)new AntUrlPathMatcher(), map);
        filterChainProxy.setFilterInvocationDefinitionSource((FilterInvocationDefinitionSource)fids);
        filterChainProxy.afterPropertiesSet();
        filterChainProxy.init((FilterConfig)new MockFilterConfig());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDetectsMissingFilterInvocationDefinitionSource() throws Exception {
        FilterChainProxy filterChainProxy = new FilterChainProxy();
        filterChainProxy.setApplicationContext((ApplicationContext)new StaticApplicationContext());
        filterChainProxy.afterPropertiesSet();
    }

    @Test
    public void testDoNotFilter() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("filterChain", FilterChainProxy.class);
        MockFilter filter = (MockFilter)this.appCtx.getBean("mockFilter", MockFilter.class);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/do/not/filter/somefile.html");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        filterChainProxy.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertFalse((boolean)filter.isWasInitialized());
        Assert.assertFalse((boolean)filter.isWasDoFiltered());
        Assert.assertFalse((boolean)filter.isWasDestroyed());
    }

    @Test
    public void misplacedUniversalPathShouldBeDetected() throws Exception {
        try {
            this.appCtx.getBean("newFilterChainProxyWrongPathOrder", FilterChainProxy.class);
            Assert.fail((String)"Expected BeanCreationException");
        }
        catch (BeanCreationException beanCreationException) {
            // empty catch block
        }
    }

    @Test
    public void normalOperation() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("filterChain", FilterChainProxy.class);
        this.doNormalOperation(filterChainProxy);
    }

    @Test
    public void proxyPathWithoutLowerCaseConversionShouldntMatchDifferentCasePath() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("filterChainNonLowerCase", FilterChainProxy.class);
        Assert.assertNull((Object)filterChainProxy.getFilters("/some/other/path/blah"));
    }

    @Test
    public void normalOperationWithNewConfig() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("newFilterChainProxy", FilterChainProxy.class);
        this.checkPathAndFilterOrder(filterChainProxy);
        this.doNormalOperation(filterChainProxy);
    }

    @Test
    public void normalOperationWithNewConfigRegex() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("newFilterChainProxyRegex", FilterChainProxy.class);
        this.checkPathAndFilterOrder(filterChainProxy);
        this.doNormalOperation(filterChainProxy);
    }

    @Test
    public void normalOperationWithNewConfigNonNamespace() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("newFilterChainProxyNonNamespace", FilterChainProxy.class);
        this.checkPathAndFilterOrder(filterChainProxy);
        this.doNormalOperation(filterChainProxy);
    }

    @Test
    public void pathWithNoMatchHasNoFilters() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("newFilterChainProxyNoDefaultPath", FilterChainProxy.class);
        Assert.assertEquals(null, (Object)filterChainProxy.getFilters("/nomatch"));
    }

    @Test
    public void urlStrippingPropertyIsRespected() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("newFilterChainProxyNoDefaultPath", FilterChainProxy.class);
        String url = "/blah.bar?x=something";
        Assert.assertNotNull((Object)filterChainProxy.getFilters(url));
        Assert.assertEquals((long)2L, (long)filterChainProxy.getFilters(url).size());
        filterChainProxy.setStripQueryStringFromUrls(false);
        Assert.assertNull((Object)filterChainProxy.getFilters(url));
    }

    private void checkPathAndFilterOrder(FilterChainProxy filterChainProxy) throws Exception {
        List filters = filterChainProxy.getFilters("/foo/blah");
        Assert.assertEquals((long)1L, (long)filters.size());
        Assert.assertTrue((boolean)(filters.get(0) instanceof MockFilter));
        filters = filterChainProxy.getFilters("/some/other/path/blah");
        Assert.assertNotNull((Object)filters);
        Assert.assertEquals((long)3L, (long)filters.size());
        Assert.assertTrue((boolean)(filters.get(0) instanceof HttpSessionContextIntegrationFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof MockFilter));
        Assert.assertTrue((boolean)(filters.get(2) instanceof MockFilter));
        filters = filterChainProxy.getFilters("/do/not/filter");
        Assert.assertEquals((long)0L, (long)filters.size());
        filters = filterChainProxy.getFilters("/another/nonspecificmatch");
        Assert.assertEquals((long)3L, (long)filters.size());
        Assert.assertTrue((boolean)(filters.get(0) instanceof HttpSessionContextIntegrationFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof AuthenticationProcessingFilter));
        Assert.assertTrue((boolean)(filters.get(2) instanceof MockFilter));
    }

    private void doNormalOperation(FilterChainProxy filterChainProxy) throws Exception {
        MockFilter filter = (MockFilter)this.appCtx.getBean("mockFilter", MockFilter.class);
        Assert.assertFalse((boolean)filter.isWasInitialized());
        Assert.assertFalse((boolean)filter.isWasDoFiltered());
        Assert.assertFalse((boolean)filter.isWasDestroyed());
        filterChainProxy.init((FilterConfig)new MockFilterConfig());
        Assert.assertTrue((boolean)filter.isWasInitialized());
        Assert.assertFalse((boolean)filter.isWasDoFiltered());
        Assert.assertFalse((boolean)filter.isWasDestroyed());
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/foo/secure/super/somefile.html");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        filterChainProxy.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((boolean)filter.isWasInitialized());
        Assert.assertTrue((boolean)filter.isWasDoFiltered());
        Assert.assertFalse((boolean)filter.isWasDestroyed());
        request.setServletPath("/a/path/which/doesnt/match/any/filter.html");
        filterChainProxy.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        filterChainProxy.destroy();
        Assert.assertTrue((boolean)filter.isWasInitialized());
        Assert.assertTrue((boolean)filter.isWasDoFiltered());
        Assert.assertTrue((boolean)filter.isWasDestroyed());
    }

    private class MockConfigAttribute
    implements ConfigAttribute {
        private MockConfigAttribute() {
        }

        public String getAttribute() {
            return null;
        }
    }
}

