/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.rememberme;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.TestDataSource;
import org.springframework.security.ui.rememberme.JdbcTokenRepositoryImpl;
import org.springframework.security.ui.rememberme.PersistentRememberMeToken;

public class JdbcTokenRepositoryImplTests {
    private static TestDataSource dataSource;
    private JdbcTokenRepositoryImpl repo;
    private JdbcTemplate template;

    @BeforeClass
    public static void createDataSource() {
        dataSource = new TestDataSource("tokenrepotest");
    }

    @AfterClass
    public static void clearDataSource() throws Exception {
        dataSource.destroy();
        dataSource = null;
    }

    @Before
    public void populateDatabase() {
        this.repo = new JdbcTokenRepositoryImpl();
        this.repo.setDataSource((DataSource)((Object)dataSource));
        this.repo.initDao();
        this.template = this.repo.getJdbcTemplate();
        this.template.execute("create table persistent_logins (username varchar not null, series varchar not null, token varchar not null, last_used timestamp not null)");
    }

    @After
    public void clearData() {
        this.template.execute("drop table persistent_logins");
    }

    @Test
    public void createNewTokenInsertsCorrectData() {
        Date currentDate = new Date();
        PersistentRememberMeToken token = new PersistentRememberMeToken("joeuser", "joesseries", "atoken", currentDate);
        this.repo.createNewToken(token);
        Map results = this.template.queryForMap("select * from persistent_logins");
        Assert.assertEquals((Object)currentDate, results.get("last_used"));
        Assert.assertEquals((Object)"joeuser", results.get("username"));
        Assert.assertEquals((Object)"joesseries", results.get("series"));
        Assert.assertEquals((Object)"atoken", results.get("token"));
    }

    @Test
    public void retrievingTokenReturnsCorrectData() {
        this.template.execute("insert into persistent_logins (series, username, token, last_used) values ('joesseries', 'joeuser', 'atoken', '2007-10-09 18:19:25.000000000')");
        PersistentRememberMeToken token = this.repo.getTokenForSeries("joesseries");
        Assert.assertEquals((Object)"joeuser", (Object)token.getUsername());
        Assert.assertEquals((Object)"joesseries", (Object)token.getSeries());
        Assert.assertEquals((Object)"atoken", (Object)token.getTokenValue());
        Assert.assertEquals((Object)Timestamp.valueOf("2007-10-09 18:19:25.000000000"), (Object)token.getDate());
    }

    @Test
    public void retrievingTokenWithDuplicateSeriesReturnsNull() {
        this.template.execute("insert into persistent_logins (series, username, token, last_used) values ('joesseries', 'joeuser', 'atoken2', '2007-10-19 18:19:25.000000000')");
        this.template.execute("insert into persistent_logins (series, username, token, last_used) values ('joesseries', 'joeuser', 'atoken', '2007-10-09 18:19:25.000000000')");
        Assert.assertNull((Object)this.repo.getTokenForSeries("joesseries"));
    }

    @Test
    public void removingUserTokensDeletesData() {
        this.template.execute("insert into persistent_logins (series, username, token, last_used) values ('joesseries2', 'joeuser', 'atoken2', '2007-10-19 18:19:25.000000000')");
        this.template.execute("insert into persistent_logins (series, username, token, last_used) values ('joesseries', 'joeuser', 'atoken', '2007-10-09 18:19:25.000000000')");
        this.repo.removeUserTokens("joeuser");
        List results = this.template.queryForList("select * from persistent_logins where username = 'joeuser'");
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void updatingTokenModifiesTokenValueAndLastUsed() {
        Timestamp ts = new Timestamp(System.currentTimeMillis() - 1L);
        this.template.execute("insert into persistent_logins (series, username, token, last_used) values ('joesseries', 'joeuser', 'atoken', '" + ts.toString() + "')");
        this.repo.updateToken("joesseries", "newtoken", new Date());
        Map results = this.template.queryForMap("select * from persistent_logins where series = 'joesseries'");
        Assert.assertEquals((Object)"joeuser", results.get("username"));
        Assert.assertEquals((Object)"joesseries", results.get("series"));
        Assert.assertEquals((Object)"newtoken", results.get("token"));
        Date lastUsed = (Date)results.get("last_used");
        Assert.assertTrue((lastUsed.getTime() > ts.getTime() ? 1 : 0) != 0);
    }

    @Test
    public void createTableOnStartupCreatesCorrectTable() {
        this.template.execute("drop table persistent_logins");
        this.repo = new JdbcTokenRepositoryImpl();
        this.repo.setDataSource((DataSource)((Object)dataSource));
        this.repo.setCreateTableOnStartup(true);
        this.repo.initDao();
        this.template.queryForList("select username,series,token,last_used from persistent_logins");
    }
}

