/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.logout;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.ui.logout.LogoutFilter;
import org.springframework.security.ui.logout.LogoutHandler;
import org.springframework.security.ui.logout.SecurityContextLogoutHandler;

public class LogoutHandlerTests
extends TestCase {
    LogoutFilter filter;

    protected void setUp() throws Exception {
        this.filter = new LogoutFilter("/success", new LogoutHandler[]{new SecurityContextLogoutHandler()});
    }

    public void testRequiresLogoutUrlWorksWithPathParams() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setRequestURI("/j_spring_security_logout;someparam=blah?otherparam=blah");
        LogoutHandlerTests.assertTrue((boolean)this.filter.requiresLogout((HttpServletRequest)request, (HttpServletResponse)response));
    }

    public void testRequiresLogoutUrlWorksWithQueryParams() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/context");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setRequestURI("/context/j_spring_security_logout?param=blah");
        LogoutHandlerTests.assertTrue((boolean)this.filter.requiresLogout((HttpServletRequest)request, (HttpServletResponse)response));
    }
}

