/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.rcp;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.providers.rcp.RemoteAuthenticationException;
import org.springframework.security.providers.rcp.RemoteAuthenticationManagerImpl;

public class RemoteAuthenticationManagerImplTests
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(RemoteAuthenticationManagerImplTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testFailedAuthenticationReturnsRemoteAuthenticationException() {
        RemoteAuthenticationManagerImpl manager = new RemoteAuthenticationManagerImpl();
        manager.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(false));
        try {
            manager.attemptAuthentication("rod", "password");
            RemoteAuthenticationManagerImplTests.fail((String)"Should have thrown RemoteAuthenticationException");
        }
        catch (RemoteAuthenticationException expected) {
            RemoteAuthenticationManagerImplTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() {
        RemoteAuthenticationManagerImpl manager = new RemoteAuthenticationManagerImpl();
        manager.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(true));
        RemoteAuthenticationManagerImplTests.assertNotNull((Object)manager.getAuthenticationManager());
    }

    public void testStartupChecksAuthenticationManagerSet() throws Exception {
        RemoteAuthenticationManagerImpl manager = new RemoteAuthenticationManagerImpl();
        try {
            manager.afterPropertiesSet();
            RemoteAuthenticationManagerImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RemoteAuthenticationManagerImplTests.assertTrue((boolean)true);
        }
        manager.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(true));
        manager.afterPropertiesSet();
        RemoteAuthenticationManagerImplTests.assertTrue((boolean)true);
    }

    public void testSuccessfulAuthentication() {
        RemoteAuthenticationManagerImpl manager = new RemoteAuthenticationManagerImpl();
        manager.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(true));
        GrantedAuthority[] result = manager.attemptAuthentication("rod", "password");
        RemoteAuthenticationManagerImplTests.assertTrue((boolean)true);
    }
}

