/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.encoding;

import junit.framework.TestCase;
import org.springframework.security.providers.encoding.PlaintextPasswordEncoder;

public class PlaintextPasswordEncoderTests
extends TestCase {
    public void testBasicFunctionality() {
        PlaintextPasswordEncoder pe = new PlaintextPasswordEncoder();
        String raw = "abc123";
        String rawDiffCase = "AbC123";
        String badRaw = "abc321";
        String salt = "THIS_IS_A_SALT";
        String encoded = pe.encodePassword(raw, (Object)salt);
        PlaintextPasswordEncoderTests.assertEquals((String)"abc123{THIS_IS_A_SALT}", (String)encoded);
        PlaintextPasswordEncoderTests.assertTrue((boolean)pe.isPasswordValid(encoded, raw, (Object)salt));
        PlaintextPasswordEncoderTests.assertFalse((boolean)pe.isPasswordValid(encoded, badRaw, (Object)salt));
        PlaintextPasswordEncoderTests.assertFalse((boolean)pe.isIgnorePasswordCase());
        encoded = pe.encodePassword(rawDiffCase, (Object)salt);
        PlaintextPasswordEncoderTests.assertFalse((boolean)pe.isPasswordValid(encoded, raw, (Object)salt));
        pe = new PlaintextPasswordEncoder();
        pe.setIgnorePasswordCase(true);
        encoded = pe.encodePassword(rawDiffCase, (Object)salt);
        PlaintextPasswordEncoderTests.assertTrue((boolean)pe.isPasswordValid(encoded, raw, (Object)salt));
        PlaintextPasswordEncoderTests.assertFalse((boolean)pe.isPasswordValid(encoded, badRaw, (Object)salt));
    }

    public void testMergeDemerge() {
        PlaintextPasswordEncoder pwd = new PlaintextPasswordEncoder();
        String merged = pwd.encodePassword("password", (Object)"foo");
        String[] demerged = pwd.obtainPasswordAndSalt(merged);
        PlaintextPasswordEncoderTests.assertEquals((String)"password", (String)demerged[0]);
        PlaintextPasswordEncoderTests.assertEquals((String)"foo", (String)demerged[1]);
    }
}

