/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Iterator;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.ITargetObject;
import org.springframework.security.MockJoinPoint;
import org.springframework.security.OtherTargetObject;
import org.springframework.security.TargetObject;
import org.springframework.security.intercept.method.MapBasedMethodDefinitionSource;
import org.springframework.security.intercept.method.MethodDefinitionSourceEditor;

public class MethodDefinitionSourceEditorTests
extends TestCase {
    public MethodDefinitionSourceEditorTests() {
    }

    public MethodDefinitionSourceEditorTests(String arg0) {
        super(arg0);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAspectJJointPointLookup() throws Exception {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.springframework.security.TargetObject.countLength=ROLE_ONE,ROLE_TWO,RUN_AS_ENTRY");
        MapBasedMethodDefinitionSource map = (MapBasedMethodDefinitionSource)editor.getValue();
        Class<TargetObject> clazz = TargetObject.class;
        Method method = clazz.getMethod("countLength", String.class);
        MockJoinPoint joinPoint = new MockJoinPoint(new TargetObject(), method);
        ConfigAttributeDefinition returnedCountLength = map.getAttributes((Object)joinPoint);
        ConfigAttributeDefinition expectedCountLength = new ConfigAttributeDefinition(new String[]{"ROLE_ONE", "ROLE_TWO", "RUN_AS_ENTRY"});
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedCountLength, (Object)returnedCountLength);
    }

    public void testClassNameNotFoundResultsInException() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        try {
            editor.setAsText("org.springframework.security.DOES_NOT_EXIST_NAME=FOO,BAR");
            MethodDefinitionSourceEditorTests.fail((String)"Should have given IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodDefinitionSourceEditorTests.assertTrue((boolean)true);
        }
    }

    public void testClassNameNotInProperFormatResultsInException() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        try {
            editor.setAsText("DOES_NOT_EXIST_NAME=FOO,BAR");
            MethodDefinitionSourceEditorTests.fail((String)"Should have given IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodDefinitionSourceEditorTests.assertTrue((boolean)true);
        }
    }

    public void testClassNameValidButMethodNameInvalidResultsInException() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        try {
            editor.setAsText("org.springframework.security.TargetObject.INVALID_METHOD=FOO,BAR");
            MethodDefinitionSourceEditorTests.fail((String)"Should have given IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodDefinitionSourceEditorTests.assertTrue((boolean)true);
        }
    }

    public void testConcreteClassInvocationsAlsoReturnDefinitionsAgainstInterface() throws Exception {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.springframework.security.ITargetObject.computeHashCode*=ROLE_FROM_INTERFACE\r\norg.springframework.security.ITargetObject.makeLower*=ROLE_FROM_INTERFACE\r\norg.springframework.security.ITargetObject.makeUpper*=ROLE_FROM_INTERFACE\r\norg.springframework.security.TargetObject.computeHashCode*=ROLE_FROM_TO\r\norg.springframework.security.OtherTargetObject.computeHashCode*=ROLE_FROM_OTO\r\norg.springframework.security.OtherTargetObject.makeUpper*=ROLE_FROM_IMPLEMENTATION");
        MapBasedMethodDefinitionSource map = (MapBasedMethodDefinitionSource)editor.getValue();
        MethodDefinitionSourceEditorTests.assertEquals((int)6, (int)map.getMethodMapSize());
        ConfigAttributeDefinition returnedMakeLower = map.getAttributes((Object)new MockMethodInvocation(ITargetObject.class, "makeLowerCase", new Class[]{String.class}, new OtherTargetObject()));
        ConfigAttributeDefinition expectedMakeLower = new ConfigAttributeDefinition("ROLE_FROM_INTERFACE");
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedMakeLower, (Object)returnedMakeLower);
        ConfigAttributeDefinition returnedMakeUpper = map.getAttributes((Object)new MockMethodInvocation(ITargetObject.class, "makeUpperCase", new Class[]{String.class}, new OtherTargetObject()));
        ConfigAttributeDefinition expectedMakeUpper = new ConfigAttributeDefinition(new String[]{"ROLE_FROM_IMPLEMENTATION"});
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedMakeUpper, (Object)returnedMakeUpper);
        ConfigAttributeDefinition returnedComputeHashCode = map.getAttributes((Object)new MockMethodInvocation(ITargetObject.class, "computeHashCode", new Class[]{String.class}, new OtherTargetObject()));
        ConfigAttributeDefinition expectedComputeHashCode = new ConfigAttributeDefinition(new String[]{"ROLE_FROM_OTO"});
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedComputeHashCode, (Object)returnedComputeHashCode);
        returnedComputeHashCode = map.getAttributes((Object)new MockMethodInvocation(ITargetObject.class, "computeHashCode", new Class[]{String.class}, new TargetObject()));
        expectedComputeHashCode = new ConfigAttributeDefinition(new String[]{"ROLE_FROM_TO"});
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedComputeHashCode, (Object)returnedComputeHashCode);
    }

    public void testEmptyStringReturnsEmptyMap() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("");
        MapBasedMethodDefinitionSource map = (MapBasedMethodDefinitionSource)editor.getValue();
        MethodDefinitionSourceEditorTests.assertEquals((int)0, (int)map.getMethodMapSize());
    }

    public void testIterator() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.springframework.security.TargetObject.countLength=ROLE_ONE,ROLE_TWO,RUN_AS_ENTRY\r\norg.springframework.security.TargetObject.make*=ROLE_NINE,ROLE_SUPERVISOR");
        MapBasedMethodDefinitionSource map = (MapBasedMethodDefinitionSource)editor.getValue();
        Iterator iter = map.getConfigAttributeDefinitions().iterator();
        int counter = 0;
        while (iter.hasNext()) {
            iter.next();
            ++counter;
        }
        MethodDefinitionSourceEditorTests.assertEquals((int)3, (int)counter);
    }

    public void testMultiMethodParsing() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.springframework.security.TargetObject.countLength=ROLE_ONE,ROLE_TWO,RUN_AS_ENTRY\r\norg.springframework.security.TargetObject.make*=ROLE_NINE,ROLE_SUPERVISOR");
        MapBasedMethodDefinitionSource map = (MapBasedMethodDefinitionSource)editor.getValue();
        MethodDefinitionSourceEditorTests.assertEquals((int)3, (int)map.getMethodMapSize());
    }

    public void testMultiMethodParsingWhereLaterMethodsOverrideEarlierMethods() throws Exception {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.springframework.security.TargetObject.*=ROLE_GENERAL\r\norg.springframework.security.TargetObject.makeLower*=ROLE_LOWER\r\norg.springframework.security.TargetObject.make*=ROLE_MAKE\r\norg.springframework.security.TargetObject.makeUpper*=ROLE_UPPER");
        MapBasedMethodDefinitionSource map = (MapBasedMethodDefinitionSource)editor.getValue();
        MethodDefinitionSourceEditorTests.assertEquals((int)14, (int)map.getMethodMapSize());
        ConfigAttributeDefinition returnedMakeLower = map.getAttributes((Object)new MockMethodInvocation(ITargetObject.class, "makeLowerCase", new Class[]{String.class}, new TargetObject()));
        ConfigAttributeDefinition expectedMakeLower = new ConfigAttributeDefinition("ROLE_LOWER");
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedMakeLower, (Object)returnedMakeLower);
        ConfigAttributeDefinition returnedMakeUpper = map.getAttributes((Object)new MockMethodInvocation(ITargetObject.class, "makeUpperCase", new Class[]{String.class}, new TargetObject()));
        ConfigAttributeDefinition expectedMakeUpper = new ConfigAttributeDefinition("ROLE_UPPER");
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedMakeUpper, (Object)returnedMakeUpper);
        ConfigAttributeDefinition returnedCountLength = map.getAttributes((Object)new MockMethodInvocation(ITargetObject.class, "countLength", new Class[]{String.class}, new TargetObject()));
        ConfigAttributeDefinition expectedCountLength = new ConfigAttributeDefinition("ROLE_GENERAL");
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedCountLength, (Object)returnedCountLength);
    }

    public void testNullIsReturnedByMethodDefinitionSourceWhenMethodInvocationNotDefined() throws Exception {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.springframework.security.TargetObject.countLength=ROLE_ONE,ROLE_TWO,RUN_AS_ENTRY");
        MapBasedMethodDefinitionSource map = (MapBasedMethodDefinitionSource)editor.getValue();
        ConfigAttributeDefinition configAttributeDefinition = map.getAttributes((Object)new MockMethodInvocation(ITargetObject.class, "makeLowerCase", new Class[]{String.class}, new TargetObject()));
        MethodDefinitionSourceEditorTests.assertNull((Object)configAttributeDefinition);
    }

    public void testNullReturnsEmptyMap() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText(null);
        MapBasedMethodDefinitionSource map = (MapBasedMethodDefinitionSource)editor.getValue();
        MethodDefinitionSourceEditorTests.assertEquals((int)0, (int)map.getMethodMapSize());
    }

    public void testSingleMethodParsing() throws Exception {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.springframework.security.TargetObject.countLength=ROLE_ONE,ROLE_TWO,RUN_AS_ENTRY");
        MapBasedMethodDefinitionSource map = (MapBasedMethodDefinitionSource)editor.getValue();
        ConfigAttributeDefinition returnedCountLength = map.getAttributes((Object)new MockMethodInvocation(ITargetObject.class, "countLength", new Class[]{String.class}, new TargetObject()));
        ConfigAttributeDefinition expectedCountLength = new ConfigAttributeDefinition(new String[]{"ROLE_ONE", "ROLE_TWO", "RUN_AS_ENTRY"});
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedCountLength, (Object)returnedCountLength);
    }

    private class MockMethodInvocation
    implements MethodInvocation {
        private Method method;
        private Object targetObject;

        public MockMethodInvocation(Class clazz, String methodName, Class[] parameterTypes, Object targetObject) throws NoSuchMethodException {
            this.method = clazz.getMethod(methodName, parameterTypes);
            this.targetObject = targetObject;
        }

        public Object[] getArguments() {
            return null;
        }

        public Method getMethod() {
            return this.method;
        }

        public AccessibleObject getStaticPart() {
            return null;
        }

        public Object getThis() {
            return this.targetObject;
        }

        public Object proceed() throws Throwable {
            return null;
        }
    }
}

