/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.Authentication;
import org.springframework.security.config.SecurityConfigurationException;
import org.springframework.security.providers.ProviderManager;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.ldap.LdapAuthenticationProvider;
import org.springframework.security.userdetails.ldap.InetOrgPersonContextMapper;
import org.springframework.security.userdetails.ldap.LdapUserDetailsImpl;
import org.springframework.security.util.FieldUtils;
import org.springframework.security.util.InMemoryXmlApplicationContext;

public class LdapProviderBeanDefinitionParserTests {
    InMemoryXmlApplicationContext appCtx;

    @After
    public void closeAppContext() {
        if (this.appCtx != null) {
            this.appCtx.close();
            this.appCtx = null;
        }
    }

    @Test
    public void simpleProviderAuthenticatesCorrectly() {
        this.setContext("<ldap-server /> <ldap-authentication-provider group-search-filter='member={0}' />");
        LdapAuthenticationProvider provider = this.getProvider();
        Authentication auth = provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"ben", (Object)"benspassword"));
        LdapUserDetailsImpl ben = (LdapUserDetailsImpl)auth.getPrincipal();
        Assert.assertEquals((long)3L, (long)ben.getAuthorities().length);
    }

    @Test(expected=SecurityConfigurationException.class)
    public void missingServerEltCausesConfigException() {
        this.setContext("<ldap-authentication-provider />");
    }

    @Test
    public void supportsPasswordComparisonAuthentication() {
        this.setContext("<ldap-server /> <ldap-authentication-provider user-dn-pattern='uid={0},ou=people'>    <password-compare /></ldap-authentication-provider>");
        LdapAuthenticationProvider provider = this.getProvider();
        provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"ben", (Object)"benspassword"));
    }

    @Test
    public void supportsPasswordComparisonAuthenticationWithHashAttribute() {
        this.setContext("<ldap-server /> <ldap-authentication-provider user-dn-pattern='uid={0},ou=people'>    <password-compare password-attribute='uid' hash='plaintext'/></ldap-authentication-provider>");
        LdapAuthenticationProvider provider = this.getProvider();
        provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"ben", (Object)"ben"));
    }

    @Test
    public void supportsPasswordComparisonAuthenticationWithPasswordEncoder() {
        this.setContext("<ldap-server /> <ldap-authentication-provider user-dn-pattern='uid={0},ou=people'>    <password-compare password-attribute='uid'>        <password-encoder hash='plaintext'/>    </password-compare></ldap-authentication-provider>");
        LdapAuthenticationProvider provider = this.getProvider();
        provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"ben", (Object)"ben"));
    }

    @Test
    public void detectsNonStandardServerId() {
        this.setContext("<ldap-server id='myServer'/> <ldap-authentication-provider />");
    }

    @Test
    public void inetOrgContextMapperIsSupported() throws Exception {
        this.setContext("<ldap-server id='someServer' url='ldap://127.0.0.1:343/dc=springframework,dc=org'/><ldap-authentication-provider user-details-class='inetOrgPerson'/>");
        LdapAuthenticationProvider provider = this.getProvider();
        Assert.assertTrue((boolean)(FieldUtils.getFieldValue((Object)provider, (String)"userDetailsContextMapper") instanceof InetOrgPersonContextMapper));
    }

    private void setContext(String context) {
        this.appCtx = new InMemoryXmlApplicationContext(context);
    }

    private LdapAuthenticationProvider getProvider() {
        ProviderManager authManager = (ProviderManager)this.appCtx.getBean("_authenticationManager");
        Assert.assertEquals((long)1L, (long)authManager.getProviders().size());
        LdapAuthenticationProvider provider = (LdapAuthenticationProvider)authManager.getProviders().get(0);
        return provider;
    }
}

