/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.ConfigAttributeEditor;
import org.springframework.security.SecurityConfig;

public class ConfigAttributeEditorTests
extends TestCase {
    private static final String[] ATTRIBUTES = new String[]{"A", "B"};

    public ConfigAttributeEditorTests() {
    }

    public ConfigAttributeEditorTests(String arg0) {
        super(arg0);
    }

    public void testCorrectOperation() {
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        editor.setAsText("HELLO,DOCTOR,NAME,YESTERDAY,TOMORROW");
        ConfigAttributeDefinition result = (ConfigAttributeDefinition)editor.getValue();
        Iterator iter = result.getConfigAttributes().iterator();
        int position = 0;
        while (iter.hasNext()) {
            ++position;
            iter.next();
        }
        ConfigAttributeEditorTests.assertEquals((int)5, (int)position);
        ConfigAttributeEditorTests.assertEquals((int)5, (int)result.getConfigAttributes().size());
        ConfigAttributeEditorTests.assertTrue((boolean)result.contains((ConfigAttribute)new SecurityConfig("HELLO")));
        ConfigAttributeEditorTests.assertTrue((boolean)result.contains((ConfigAttribute)new SecurityConfig("TOMORROW")));
        ConfigAttributeEditorTests.assertFalse((boolean)result.contains((ConfigAttribute)new SecurityConfig("FOOBAR")));
    }

    public void testEmptyStringReturnsNull() {
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        editor.setAsText("");
        ConfigAttributeDefinition result = (ConfigAttributeDefinition)editor.getValue();
        ConfigAttributeEditorTests.assertTrue((result == null ? 1 : 0) != 0);
    }

    public void testEqualsHandlingWhenDifferentObjectTypes() {
        ConfigAttributeDefinition def1 = new ConfigAttributeDefinition(ATTRIBUTES);
        ConfigAttributeEditorTests.assertTrue((!def1.equals((Object)"A_STRING") ? 1 : 0) != 0);
    }

    public void testEqualsHandlingWhenExactlyEqual() {
        ConfigAttributeDefinition def1 = new ConfigAttributeDefinition(ATTRIBUTES);
        ConfigAttributeDefinition def2 = new ConfigAttributeDefinition(ATTRIBUTES);
        ConfigAttributeEditorTests.assertEquals((Object)def1, (Object)def2);
    }

    public void testEqualsHandlingWhenOrderingNotEqual() {
        ConfigAttributeDefinition def1 = new ConfigAttributeDefinition(ATTRIBUTES);
        ConfigAttributeDefinition def2 = new ConfigAttributeDefinition(new String[]{"B", "A"});
        ConfigAttributeEditorTests.assertFalse((boolean)def1.equals((Object)def2));
    }

    public void testEqualsHandlingWhenTestObjectHasNoAttributes() {
        ConfigAttributeDefinition def1 = new ConfigAttributeDefinition(ATTRIBUTES);
        ConfigAttributeDefinition def2 = new ConfigAttributeDefinition(new String[0]);
        ConfigAttributeEditorTests.assertFalse((boolean)def1.equals((Object)def2));
        ConfigAttributeEditorTests.assertFalse((boolean)def2.equals((Object)def1));
    }

    public void testNullReturnsNull() {
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        editor.setAsText(null);
        ConfigAttributeDefinition result = (ConfigAttributeDefinition)editor.getValue();
        ConfigAttributeEditorTests.assertTrue((result == null ? 1 : 0) != 0);
    }

    public void testStripsTrailingAndLeadingSpaces() {
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        editor.setAsText("  HELLO, DOCTOR,NAME,  YESTERDAY ,TOMORROW ");
        ConfigAttributeDefinition result = (ConfigAttributeDefinition)editor.getValue();
        Iterator iter = result.getConfigAttributes().iterator();
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        ConfigAttributeEditorTests.assertEquals((String)"HELLO", (String)((ConfigAttribute)list.get(0)).getAttribute());
        ConfigAttributeEditorTests.assertEquals((String)"DOCTOR", (String)((ConfigAttribute)list.get(1)).getAttribute());
        ConfigAttributeEditorTests.assertEquals((String)"NAME", (String)((ConfigAttribute)list.get(2)).getAttribute());
        ConfigAttributeEditorTests.assertEquals((String)"YESTERDAY", (String)((ConfigAttribute)list.get(3)).getAttribute());
        ConfigAttributeEditorTests.assertEquals((String)"TOMORROW", (String)((ConfigAttribute)list.get(4)).getAttribute());
    }

    public void testToString() {
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        editor.setAsText("KOALA,KANGAROO,EMU,WOMBAT");
        ConfigAttributeDefinition result = (ConfigAttributeDefinition)editor.getValue();
        ConfigAttributeEditorTests.assertEquals((String)"[KOALA, KANGAROO, EMU, WOMBAT]", (String)result.toString());
    }
}

