/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.logging.access;

import com.jaspersoft.jasperserver.api.logging.access.domain.AccessEvent;
import com.jaspersoft.jasperserver.export.modules.BaseExporterModule;
import com.jaspersoft.jasperserver.export.modules.logging.access.AccessModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.logging.access.beans.AccessEventBean;
import java.util.List;
import org.dom4j.Element;

public class AccessEventsExporter
extends BaseExporterModule {
    private AccessModuleConfiguration accessModuleConfiguration;
    private String includeAccessEvents;
    private int maxEventsPerIteration = 50;

    public void setAccessModuleConfiguration(AccessModuleConfiguration accessModuleConfiguration) {
        this.accessModuleConfiguration = accessModuleConfiguration;
    }

    public void setMaxEventsPerIteration(int maxEventsPerIteration) {
        this.maxEventsPerIteration = maxEventsPerIteration;
    }

    public void setIncludeAccessEvents(String includeAccessEvents) {
        this.includeAccessEvents = includeAccessEvents;
    }

    public boolean toProcess() {
        return this.isToProcess();
    }

    protected boolean isToProcess() {
        return this.exportEverything && this.hasParameter(this.includeAccessEvents) && this.hasAccessEvents();
    }

    protected boolean hasAccessEvents() {
        return this.accessModuleConfiguration.getAccessService().getAccessEventsCount() > 0;
    }

    public void process() {
        this.mkdir(this.accessModuleConfiguration.getAccessEventsDirectory());
        long counter = 0L;
        int firstResult = 0;
        List accessEventsBuffer = this.accessModuleConfiguration.getAccessService().getAllEvents(firstResult, this.maxEventsPerIteration);
        while (!accessEventsBuffer.isEmpty()) {
            commandOut.info("Exporting next " + accessEventsBuffer.size() + " accessEvents");
            for (AccessEvent accessEvent : accessEventsBuffer) {
                this.processAcessEvent(accessEvent, ++counter);
            }
            accessEventsBuffer = this.accessModuleConfiguration.getAccessService().getAllEvents(firstResult += accessEventsBuffer.size(), this.maxEventsPerIteration);
        }
        commandOut.info(counter + " accessEvents has been exported successfully");
        this.addAccessEventIndexEntry(counter);
    }

    protected String getAccessEventIndex(AccessEvent accessEvent, long counter) {
        return String.valueOf(counter);
    }

    protected void addAccessEventIndexEntry(long counter) {
        Element indexElement = this.getIndexElement();
        Element tenantElement = indexElement.addElement(this.accessModuleConfiguration.getAccessEventIndexElement());
        tenantElement.addText(String.valueOf(counter));
    }

    protected void processAcessEvent(AccessEvent accessEvent, long counter) {
        AccessEventBean accessEventBean = new AccessEventBean();
        accessEventBean.copyFrom(accessEvent);
        this.serialize(accessEventBean, this.accessModuleConfiguration.getAccessEventsDirectory(), this.getAccessEventIndex(accessEvent, counter) + ".xml", this.accessModuleConfiguration.getSerializer());
    }
}

