/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.build.utils;

import com.yahoo.platform.yui.compressor.YUICompressor;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedYUICompressor {
    private List<String> compressibleFiles = new ArrayList<String>();
    private Set<String> nonCompressibleFiles = new HashSet<String>();
    private static final String CSS = ".css";
    private static final String JS = ".js";

    public ExtendedYUICompressor() {
        this.nonCompressibleFiles.add("topic2jrxml.js");
        this.nonCompressibleFiles.add("state2jrxml.js");
    }

    public List<String> getCompressibleFiles() {
        return this.compressibleFiles;
    }

    public void setCompressibleFiles(List<String> compressibleFiles) {
        this.compressibleFiles = compressibleFiles;
    }

    public Set<String> getNonCompressibleFiles() {
        return this.nonCompressibleFiles;
    }

    public void setNonCompressibleFiles(Set<String> nonCompressibleFiles) {
        this.nonCompressibleFiles = nonCompressibleFiles;
    }

    private void collectCompressibleFiles(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.collectCompressibleFiles(f);
                continue;
            }
            if (!f.getName().endsWith(JS)) continue;
            this.compressibleFiles.add(f.getAbsolutePath());
        }
    }

    private void addFilesToIgnoreList(String filenames) {
        String[] files = filenames.split(",");
        this.nonCompressibleFiles.addAll(Arrays.asList(files));
    }

    private void compressFiles() {
        String ouptutArg = "-o";
        for (String file : this.compressibleFiles) {
            String simpleName = ExtendedYUICompressor.getSimpleFileName(file);
            if (!this.nonCompressibleFiles.contains(simpleName)) {
                System.out.println("Compressing: " + simpleName);
                String[] args = new String[]{file, ouptutArg, file};
                YUICompressor.main(args);
                continue;
            }
            System.out.println("Ignoring: " + simpleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int exit_code = 0;
        ExtendedYUICompressor compressor = new ExtendedYUICompressor();
        CmdLineParser comParser = new CmdLineParser();
        CmdLineParser.Option dir = comParser.addStringOption('d', "directory");
        CmdLineParser.Option ignore = comParser.addStringOption('i', "ignore");
        try {
            File warfile;
            String ignoreList;
            comParser.parse(args);
            String war = (String)comParser.getOptionValue(dir);
            if (war == null) {
                exit_code = 2;
                ExtendedYUICompressor.exit(exit_code);
            }
            if ((ignoreList = (String)comParser.getOptionValue(ignore)) != null && ignoreList.length() > 0) {
                compressor.addFilesToIgnoreList(ignoreList);
            }
            if ((warfile = new File(war)).exists() && warfile.isDirectory()) {
                compressor.collectCompressibleFiles(warfile);
                System.out.println("Compressing the following files:");
                System.out.println("--------------------------------");
                compressor.compressFiles();
            } else {
                System.err.println("[Error]: The file '" + war + "' is not a valid directory\n");
            }
        }
        catch (CmdLineParser.OptionException e) {
            exit_code = 1;
        }
        finally {
            ExtendedYUICompressor.exit(exit_code);
        }
    }

    private static void usage() {
        System.out.println("Usage: java -jar ExtendedYUICompressor-x.jar -d [warfile path] -i ignorefile1,ignorefile2");
        System.out.println("example: java -jar ExtendedYUICompressor-1.jar -d /target/jasperserver-pro -i wcc.css,papanii.js");
    }

    private static void exit(int code) {
        switch (code) {
            case 0: {
                System.out.println("Compression complete");
                break;
            }
            case 1: {
                System.err.println("[Error]: Command line parameters are wrong!!");
                ExtendedYUICompressor.usage();
                break;
            }
            case 2: {
                System.err.println("[Error]: Invalid war file provided");
                ExtendedYUICompressor.usage();
                break;
            }
            default: {
                System.err.println("[Error]: Unknown error!!!");
                ExtendedYUICompressor.usage();
            }
        }
        System.exit(code);
    }

    private static String getSimpleFileName(String absolutePath) {
        String regex = "\\w+[.]\\w+[.]\\w+$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(absolutePath);
        String simplename = "";
        if (matcher.find()) {
            return absolutePath.substring(matcher.start(), matcher.end());
        }
        return simplename;
    }

    private static void printFileNames(List<String> filenames) {
        for (String x : filenames) {
            System.out.println(ExtendedYUICompressor.getSimpleFileName(x));
        }
    }
}

