/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.maven.surefire.SurefireUtils;
import org.apache.maven.surefire.battery.Battery;
import org.apache.maven.surefire.battery.assertion.BatteryTestFailedException;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterManager;

public class Surefire {
    private static ResourceBundle resources = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    private List batteryHolders;
    private List reports;
    private ReporterManager reporterManager;
    private ClassLoader classLoader;
    private String reportsDirectory;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$Reporter;

    public static ResourceBundle getResources() {
        return resources;
    }

    public boolean run(List reports, List batteryHolders, String reportsDirectory) throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return this.run(reports, batteryHolders, classLoader, reportsDirectory);
    }

    public boolean run(List reports, List batteryHolders, ClassLoader classLoader, String reportsDirectory) throws Exception {
        if (reports == null || batteryHolders == null || classLoader == null) {
            throw new NullPointerException();
        }
        if (batteryHolders.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.batteryHolders = batteryHolders;
        this.reports = reports;
        this.classLoader = classLoader;
        this.reportsDirectory = reportsDirectory;
        return this.run();
    }

    public boolean run() throws Exception {
        List batts = Surefire.instantiateBatteries(this.batteryHolders, this.classLoader);
        this.reporterManager = new ReporterManager(this.instantiateReports(this.reports, this.classLoader), this.reportsDirectory);
        try {
            this.reporterManager.runStarting(100);
            if (batts.size() > 0) {
                int nbTests = 0;
                Iterator i = batts.iterator();
                while (i.hasNext()) {
                    Battery battery = (Battery)i.next();
                    int testCount = 0;
                    try {
                        testCount = battery.getTestCount();
                    }
                    catch (BatteryTestFailedException e) {
                        e.printStackTrace();
                        ReportEntry report = new ReportEntry(e, "org.apache.maven.surefire.Runner", Surefire.getResources().getString("bigProblems"), e);
                        this.reporterManager.batteryAborted(report);
                    }
                    if (testCount > 0) {
                        this.executeBattery(battery, this.reporterManager);
                        nbTests += testCount;
                    }
                    ArrayList<Object[]> list = new ArrayList<Object[]>();
                    Iterator j = battery.getSubBatteryClassNames().iterator();
                    while (j.hasNext()) {
                        String s = (String)j.next();
                        list.add(new Object[]{s, null});
                    }
                    List subBatteries = Surefire.instantiateBatteries(list, this.classLoader);
                    Iterator j2 = subBatteries.iterator();
                    while (j2.hasNext()) {
                        Battery b = (Battery)j2.next();
                        testCount = 0;
                        try {
                            testCount = b.getTestCount();
                        }
                        catch (BatteryTestFailedException e) {
                            e.printStackTrace();
                            ReportEntry report = new ReportEntry(e, "org.apache.maven.surefire.Runner", Surefire.getResources().getString("bigProblems"), e);
                            this.reporterManager.batteryAborted(report);
                        }
                        if (testCount <= 0) continue;
                        this.executeBattery(b, this.reporterManager);
                        nbTests += testCount;
                    }
                }
                if (nbTests == 0) {
                    this.reporterManager.writeMessage("There are no tests to run.");
                }
            } else {
                this.reporterManager.writeMessage("There are no batteries to run.");
            }
            this.reporterManager.runCompleted();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            ReportEntry report = new ReportEntry(ex, "org.apache.maven.surefire.Runner", Surefire.getResources().getString("bigProblems"), ex);
            this.reporterManager.runAborted(report);
        }
        this.reporterManager.resume();
        return this.reporterManager.getNbErrors() <= 0 && this.reporterManager.getNbFailures() <= 0;
    }

    public void executeBattery(Battery battery, ReporterManager reportManager) throws Exception {
        try {
            String rawString = Surefire.getResources().getString("suiteExecutionStarting");
            ReportEntry report = new ReportEntry(this, battery.getBatteryName(), rawString);
            reportManager.batteryStarting(report);
            try {
                battery.execute(reportManager);
                rawString = Surefire.getResources().getString("suiteCompletedNormally");
                report = new ReportEntry(this, battery.getBatteryName(), rawString);
                reportManager.batteryCompleted(report);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                rawString = Surefire.getResources().getString("executeException");
                report = new ReportEntry(this, battery.getBatteryName(), rawString, e);
                reportManager.batteryAborted(report);
            }
            reportManager.runCompleted();
            reportManager.dispose();
        }
        catch (Throwable ex) {
            ReportEntry report = new ReportEntry(ex, "org.apache.maven.surefire.Runner", Surefire.getResources().getString("bigProblems"), ex);
            reportManager.runAborted(report);
        }
    }

    public static List instantiateBatteries(List batteryHolders, ClassLoader loader) throws Exception {
        ArrayList<Object> batteries = new ArrayList<Object>();
        for (int i = 0; i < batteryHolders.size(); ++i) {
            Object[] holder = (Object[])batteryHolders.get(i);
            Object battery = SurefireUtils.instantiateBattery(holder, loader);
            if (battery == null) continue;
            batteries.add(battery);
        }
        return batteries;
    }

    protected List instantiateReports(List reportClassNames, ClassLoader classLoader) throws Exception {
        ArrayList<Reporter> reports = new ArrayList<Reporter>();
        boolean fail = false;
        ClassLoader reporterClassLoader = (class$org$apache$maven$surefire$report$Reporter == null ? (class$org$apache$maven$surefire$report$Reporter = Surefire.class$("org.apache.maven.surefire.report.Reporter")) : class$org$apache$maven$surefire$report$Reporter).getClassLoader();
        Iterator i = reportClassNames.iterator();
        while (i.hasNext()) {
            String reportClassName = (String)i.next();
            try {
                Class<?> reportClass = reporterClassLoader.loadClass(reportClassName);
                Reporter report = (Reporter)reportClass.newInstance();
                report.setReportsDirectory(this.reportsDirectory);
                reports.add(report);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (fail) {
            throw new RuntimeException("couldn't assign reports as expected");
        }
        return reports;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

