/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CustomReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.CustomDataSourceDefinition;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.CustomDataSourceValidator;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.ReportDataSourceWrapper;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class ReportDataSourceValidator
implements Validator {
    private JasperServerConstImpl constants = new JasperServerConstImpl();
    private RepositoryService repository;
    private CustomReportDataSourceServiceFactory customDataSourceFactory;
    public static final String DATASOURCE_JDBC = "jdbc";
    public static final String DATASOURCE_JNDI = "jndi";
    public static final String DATASOURCE_BEAN = "bean";

    public CustomReportDataSourceServiceFactory getCustomDataSourceFactory() {
        return this.customDataSourceFactory;
    }

    public void setCustomDataSourceFactory(CustomReportDataSourceServiceFactory customDataSourceFactory) {
        this.customDataSourceFactory = customDataSourceFactory;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public boolean supports(Class clazz) {
        return ReportDataSourceWrapper.class.isAssignableFrom(clazz);
    }

    public void validate(Object obj, Errors errors) {
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)obj;
        this.validateType(wrapper, errors);
        if (!errors.hasErrors()) {
            if (DATASOURCE_JDBC.equals(wrapper.getType())) {
                this.jdbcPropsForm(wrapper, errors);
            } else if (DATASOURCE_JNDI.equals(wrapper.getType())) {
                this.jndiPropsForm(wrapper, errors);
            } else if (DATASOURCE_BEAN.equals(wrapper.getType())) {
                this.beanPropsForm(wrapper, errors);
            }
        }
    }

    public void validateSource(ReportDataSourceWrapper wrapper, Errors errors) {
        if (wrapper.getSource() == null) {
            errors.rejectValue("source", "ReportDataSourceValidator.error.not.empty");
        }
        ReportDataSourceValidator reportDataSourceValidator = this;
        if (reportDataSourceValidator.constants.getFieldChoiceRepo().equals(wrapper.getSource()) && (wrapper.getSelectedUri() == null || wrapper.getSelectedUri().trim().length() == 0)) {
            errors.rejectValue("selectedUri", "ReportDataSourceValidator.error.not.empty");
        }
    }

    public void validateType(ReportDataSourceWrapper wrapper, Errors errors) {
        ReportDataSourceValidator reportDataSourceValidator = this;
        if (reportDataSourceValidator.constants.getFieldChoiceLocal().equals(wrapper.getSource()) && wrapper.getType() == null) {
            errors.rejectValue("type", "ReportDataSourceValidator.error.not.empty");
        }
    }

    public void jndiPropsForm(ReportDataSourceWrapper wrapper, Errors errors) {
        JndiJdbcReportDataSource jndiSource = (JndiJdbcReportDataSource)wrapper.getReportDataSource();
        if (jndiSource.getJndiName() == null || jndiSource.getJndiName().trim().length() == 0) {
            errors.rejectValue("reportDataSource.jndiName", "ReportDataSourceValidator.error.not.empty");
        } else if (!JasperServerUtil.regExValidateJndiServiceName(jndiSource.getJndiName())) {
            errors.rejectValue("reportDataSource.jndiName", "ReportDataSourceValidator.error.invalid.chars");
        }
        this.namingForm(wrapper, errors);
    }

    public void namingForm(ReportDataSourceWrapper wrapper, Errors errors) {
        ReportDataSource ds = wrapper.getReportDataSource();
        if (ds.getName() == null || ds.getName().trim().length() == 0) {
            errors.rejectValue("reportDataSource.name", "ReportDataSourceValidator.error.not.empty");
        } else if (!JasperServerUtil.regExValidateName(ds.getName())) {
            errors.rejectValue("reportDataSource.name", "ReportDataSourceValidator.error.invalid.chars");
        }
        if (ds.getLabel() == null || ds.getLabel().trim().length() == 0) {
            errors.rejectValue("reportDataSource.label", "ReportDataSourceValidator.error.not.empty");
        } else if (!JasperServerUtil.regExValidateLabel(ds.getLabel())) {
            errors.rejectValue("reportDataSource.label", "ReportDataSourceValidator.error.invalid.chars");
        }
        if (ds.getDescription() != null && ds.getDescription().trim().length() > 250) {
            errors.rejectValue("reportDataSource.description", "ReportDataSourceValidator.error.too.long");
        }
        if (wrapper.isAloneNewMode() && this.repository.repositoryPathExists(null, ds.getURIString())) {
            errors.rejectValue("reportDataSource.name", "ReportDataSourceValidator.error.duplicate");
        }
    }

    public void jdbcPropsForm(ReportDataSourceWrapper wrapper, Errors errors) {
        JdbcReportDataSource ds = (JdbcReportDataSource)wrapper.getReportDataSource();
        if (ds.getDriverClass() == null || ds.getDriverClass().trim().length() == 0) {
            errors.rejectValue("reportDataSource.driverClass", "ReportDataSourceValidator.error.not.empty");
        } else {
            ds.setDriverClass(ds.getDriverClass().trim());
            if (!JasperServerUtil.regExValidateDbDriver(ds.getDriverClass())) {
                errors.rejectValue("reportDataSource.driverClass", "ReportDataSourceValidator.error.invalid.chars");
            }
        }
        if (ds.getConnectionUrl() == null || ds.getConnectionUrl().trim().length() == 0) {
            errors.rejectValue("reportDataSource.connectionUrl", "ReportDataSourceValidator.error.not.empty");
        } else if (!JasperServerUtil.regExValidateJdbcURL(ds.getConnectionUrl())) {
            errors.rejectValue("reportDataSource.connectionUrl", "ReportDataSourceValidator.error.invalid.chars");
        }
        if (ds.getUsername() == null || ds.getUsername().trim().length() == 0) {
            errors.rejectValue("reportDataSource.username", "ReportDataSourceValidator.error.not.empty");
        }
        this.namingForm(wrapper, errors);
    }

    public void beanPropsForm(ReportDataSourceWrapper wrapper, Errors errors) {
        BeanReportDataSource beanSource = (BeanReportDataSource)wrapper.getReportDataSource();
        if (beanSource.getBeanName() == null || beanSource.getBeanName().trim().length() == 0) {
            errors.rejectValue("reportDataSource.beanName", "ReportDataSourceValidator.error.not.empty");
        }
        this.namingForm(wrapper, errors);
    }

    public void customPropsForm(ReportDataSourceWrapper wrapper, Errors errors) {
        CustomReportDataSource cds = (CustomReportDataSource)wrapper.getReportDataSource();
        CustomDataSourceDefinition cdef = this.customDataSourceFactory.getDefinitionByServiceClass(cds.getServiceClass());
        CustomDataSourceValidator val = cdef.getValidator();
        if (val != null) {
            val.validatePropertyValues(cds, errors);
        }
        this.namingForm(wrapper, errors);
    }
}

