/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.util.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;

public class ColorSelectorPanel
extends JPanel {
    private Color color = Color.BLACK;
    private String value = "[0,0,0]";
    private JButton jButtonSelect;
    private JPanel jPanelColor;
    private JTextField jTextFieldColorValue;

    public ColorSelectorPanel() {
        this.initComponents();
        this.applyI18n();
        this.setColor(null);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(Object newValue) {
        if (newValue == null) {
            this.setColor(null);
            return;
        }
        Color newColor = null;
        newColor = newValue instanceof Color ? (Color)newValue : ColorSelectorPanel.parseColorString("" + newValue);
        if (newColor == null) {
            return;
        }
        this.setColor(newColor);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (color == null) {
            this.value = null;
            this.jTextFieldColorValue.setText("");
            this.jPanelColor.setBackground(Color.WHITE);
            this.jPanelColor.setBorder(new LineBorder(Color.LIGHT_GRAY));
            this.jPanelColor.invalidate();
            this.jPanelColor.updateUI();
        } else {
            this.jPanelColor.setBorder(new LineBorder(Color.BLACK));
            this.value = "[" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "]";
            this.jPanelColor.setBackground(color);
            this.jPanelColor.invalidate();
            this.jPanelColor.updateUI();
            this.jTextFieldColorValue.setText(this.getValue());
        }
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, ""));
    }

    public static Color parseColorString(String newValue) {
        if (newValue == null) {
            return null;
        }
        if (!(newValue = newValue.trim()).startsWith("[") || !newValue.endsWith("]")) {
            Color c = Color.getColor(newValue);
            if (c == null && newValue.startsWith("#") && newValue.length() == 7) {
                int hr = Integer.parseInt(newValue.substring(1, 3), 16);
                int hg = Integer.parseInt(newValue.substring(3, 5), 16);
                int hb = Integer.parseInt(newValue.substring(5, 7), 16);
                c = new Color(hr, hg, hb);
                return c;
            }
            return null;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        String rgbValues = newValue.substring(1, newValue.length() - 1);
        try {
            StringTokenizer st = new StringTokenizer(rgbValues, ",", false);
            r = Integer.parseInt(st.nextToken());
            g = Integer.parseInt(st.nextToken());
            b = Integer.parseInt(st.nextToken());
        }
        catch (Exception ex) {
            return null;
        }
        Color c = new Color(r, g, b);
        return c;
    }

    private void initComponents() {
        this.jPanelColor = new JPanel();
        this.jTextFieldColorValue = new JTextField();
        this.jButtonSelect = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(255, 255, 255));
        this.setMinimumSize(new Dimension(45, 10));
        this.setPreferredSize(new Dimension(75, 22));
        this.jPanelColor.setLayout(null);
        this.jPanelColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanelColor.setMaximumSize(new Dimension(18, 18));
        this.jPanelColor.setMinimumSize(new Dimension(18, 8));
        this.jPanelColor.setPreferredSize(new Dimension(18, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.add((Component)this.jPanelColor, gridBagConstraints);
        this.jTextFieldColorValue.setText("[0,0,0]");
        this.jTextFieldColorValue.setBorder(null);
        this.jTextFieldColorValue.setPreferredSize(new Dimension(100, 14));
        this.jTextFieldColorValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorSelectorPanel.this.jTextFieldColorValueActionPerformed(evt);
            }
        });
        this.jTextFieldColorValue.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ColorSelectorPanel.this.jTextFieldColorValueFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jTextFieldColorValue, gridBagConstraints);
        this.jButtonSelect.setText("...");
        this.jButtonSelect.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonSelect.setMaximumSize(new Dimension(19, 19));
        this.jButtonSelect.setMinimumSize(new Dimension(19, 10));
        this.jButtonSelect.setPreferredSize(new Dimension(19, 22));
        this.jButtonSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorSelectorPanel.this.jButtonSelectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.jButtonSelect, gridBagConstraints);
    }

    private void jTextFieldColorValueFocusLost(FocusEvent evt) {
        this.jTextFieldColorValueActionPerformed(null);
    }

    private void jButtonSelectActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, "Pick a color...", this.getColor());
        if (c != null) {
            this.setColor(c);
        }
    }

    private void jTextFieldColorValueActionPerformed(ActionEvent evt) {
        Color newColor = ColorSelectorPanel.parseColorString(this.jTextFieldColorValue.getText());
        if (newColor == null) {
            this.jTextFieldColorValue.setText(this.getValue());
        }
        if (newColor != null) {
            this.setColor(newColor);
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void fireActionListenerActionPerformed(ActionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$ActionListener == null ? ColorSelectorPanel.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public void applyI18n() {
        this.jButtonSelect.setText(I18n.getString("colorSelectorPanel.buttonSelect", "..."));
    }
}

