/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.fonts;

import it.businesslogic.ireport.gui.ClassPathDialog;
import it.businesslogic.ireport.gui.fonts.CheckBoxList;
import it.businesslogic.ireport.gui.fonts.CheckBoxListEntry;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class FontsPathDialog
extends JDialog {
    private int dialogResult = 2;
    private boolean modifiedPath = false;
    private JButton jButtonCancel;
    private JButton jButtonDeselectAll;
    private JButton jButtonSave;
    private JButton jButtonSelectAll;
    private JLabel jLabelClasspath;
    private CheckBoxList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public FontsPathDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.jList1.setModel(new DefaultListModel());
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FontsPathDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                FontsPathDialog.this.modifiedPath = true;
            }
        });
        this.getRootPane().setDefaultButton(this.jButtonSave);
    }

    private void initComponents() {
        this.jLabelClasspath = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new CheckBoxList();
        this.jPanel1 = new JPanel();
        this.jButtonSelectAll = new JButton();
        this.jButtonDeselectAll = new JButton();
        this.jPanel2 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.setTitle(I18n.getString("fonts", "Classpath"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                FontsPathDialog.this.formWindowClosed(evt);
            }

            public void windowClosing(WindowEvent evt) {
                FontsPathDialog.this.formWindowClosing(evt);
            }
        });
        this.jLabelClasspath.setHorizontalAlignment(2);
        this.jLabelClasspath.setText(I18n.getString("fonts", "Fonts path"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabelClasspath, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(359, 260));
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(120, 10));
        this.jPanel1.setPreferredSize(new Dimension(120, 10));
        this.jButtonSelectAll.setText(I18n.getString("selectAll", "Select all"));
        this.jButtonSelectAll.setMaximumSize(new Dimension(200, 26));
        this.jButtonSelectAll.setMinimumSize(new Dimension(90, 26));
        this.jButtonSelectAll.setPreferredSize(new Dimension(120, 26));
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontsPathDialog.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonSelectAll, gridBagConstraints);
        this.jButtonDeselectAll.setText(I18n.getString("deSelectAll", "Deselect all"));
        this.jButtonDeselectAll.setMaximumSize(new Dimension(200, 26));
        this.jButtonDeselectAll.setMinimumSize(new Dimension(90, 26));
        this.jButtonDeselectAll.setPreferredSize(new Dimension(120, 26));
        this.jButtonDeselectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontsPathDialog.this.jButtonDeselectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonDeselectAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jButtonSave.setText(I18n.getString("saveFontPath", "Save fonts path"));
        this.jButtonSave.setMaximumSize(new Dimension(200, 26));
        this.jButtonSave.setMinimumSize(new Dimension(90, 26));
        this.jButtonSave.setPreferredSize(new Dimension(120, 26));
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontsPathDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonCancel.setText(I18n.getString("cancel", "Cancel"));
        this.jButtonCancel.setMaximumSize(new Dimension(200, 26));
        this.jButtonCancel.setMinimumSize(new Dimension(90, 26));
        this.jButtonCancel.setPreferredSize(new Dimension(120, 26));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontsPathDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jButtonDeselectAllActionPerformed(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        for (int i = 0; i < dlm.size(); ++i) {
            Object obj = dlm.getElementAt(i);
            if (!(obj instanceof JCheckBox)) continue;
            JCheckBox checkbox = (JCheckBox)obj;
            checkbox.setSelected(false);
        }
        this.jList1.updateUI();
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        for (int i = 0; i < dlm.size(); ++i) {
            Object obj = dlm.getElementAt(i);
            if (!(obj instanceof JCheckBox)) continue;
            JCheckBox checkbox = (JCheckBox)obj;
            checkbox.setSelected(true);
        }
        this.jList1.updateUI();
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.modifiedPath) {
            int ret = JOptionPane.showConfirmDialog(this, I18n.getString("saveFontsPathQuestion", "Do you want save the fontspath ?"));
            if (ret == 2) {
                return;
            }
            this.jButtonSaveActionPerformed(null);
        } else {
            this.setVisible(false);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, I18n.getString("saveFontsRestartInfo", "You have to restart iReport for the changes to take effect"));
        this.setDialogResult(0);
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ClassPathDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public void setFontspath(Vector fontPath, Vector cp) {
        String s;
        Vector<String> newcp = new Vector<String>(cp);
        Vector<String> cp_old = new Vector<String>();
        String path = System.getProperty("java.class.path");
        if (path != null && path.length() > 0) {
            StringTokenizer st = new StringTokenizer(path, System.getProperty("path.separator"));
            while (st.hasMoreTokens()) {
                s = st.nextToken();
                if (newcp.contains(s)) continue;
                newcp.add(s);
                cp_old.add(s);
            }
        }
        for (int i = 0; i < fontPath.size(); ++i) {
            s = (String)fontPath.elementAt(i);
            if (newcp.contains(s)) continue;
            newcp.add(s);
        }
        Object[] allStrings = new Object[newcp.size()];
        newcp.copyInto(allStrings);
        Arrays.sort(allStrings);
        for (int i = 0; i < allStrings.length; ++i) {
            String s2 = "" + allStrings[i];
            CheckBoxListEntry cble = new CheckBoxListEntry((Object)s2, fontPath.contains(s2));
            if (!cp.contains(s2) && !cp_old.contains(s2)) {
                cble.setRed(true);
            }
            ((DefaultListModel)this.jList1.getModel()).addElement(cble);
        }
    }

    public Vector getFontspath() {
        Vector<String> cp = new Vector<String>();
        List list = this.jList1.getCheckedItems();
        for (int i = 0; i < list.size(); ++i) {
            CheckBoxListEntry cble = (CheckBoxListEntry)list.get(i);
            cp.addElement(cble.getValue() + "");
        }
        return cp;
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
    }
}

