/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.validation.advices;

import java.lang.reflect.Method;
import org.apache.maven.doxia.validation.advices.MethodBeforeAdvice;

public abstract class AbstractSinkAdvice
implements MethodBeforeAdvice {
    public abstract void doLeaf(Method var1, Object[] var2, Object var3);

    public abstract void doStart(Method var1, Object[] var2, Object var3);

    public abstract void doEnd(Method var1, Object[] var2, Object var3);

    public final void before(Method method, Object[] args, Object instance) throws Throwable {
        String name = method.getName();
        if (AbstractSinkAdvice.hasClosing(method)) {
            this.doStart(method, args, instance);
        } else if (name.endsWith("_")) {
            this.doEnd(method, args, instance);
        } else {
            this.doLeaf(method, args, instance);
        }
    }

    private static boolean hasClosing(Method m) {
        boolean ret = false;
        if (m.getName().endsWith("-")) {
            ret = false;
        } else {
            Method[] methods = m.getDeclaringClass().getMethods();
            for (int i = 0; !ret && i < methods.length; ++i) {
                ret = methods[i].getName().equals(m.getName() + "_");
            }
        }
        return ret;
    }
}

