/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.context.impl;

import com.jaspersoft.jasperserver.api.logging.context.LoggableEvent;
import com.jaspersoft.jasperserver.api.logging.context.LoggingContext;
import com.jaspersoft.jasperserver.api.logging.context.LoggingContextProvider;
import com.jaspersoft.jasperserver.api.logging.context.impl.LoggingContextImpl;
import com.jaspersoft.jasperserver.api.logging.service.LoggingService;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicLoggingContextProvider
implements LoggingContextProvider {
    private static final Log log = LogFactory.getLog(BasicLoggingContextProvider.class);
    private LoggingService loggingService;
    private Map<Class<? extends LoggableEvent>, Boolean> enabledLoggingTypesMap;
    private final ThreadLocal<LoggingContext> threadLocalContext = new ThreadLocal<LoggingContext>(){

        @Override
        protected synchronized LoggingContext initialValue() {
            return BasicLoggingContextProvider.this.createLoggingContext();
        }
    };

    public void setLoggingService(LoggingService loggingService) {
        this.loggingService = loggingService;
    }

    public void setEnabledLoggingTypesMap(Map<Class<? extends LoggableEvent>, Boolean> enabledLoggingTypesMap) {
        this.enabledLoggingTypesMap = enabledLoggingTypesMap;
    }

    protected LoggingContext createLoggingContext() {
        LoggingContextImpl context = new LoggingContextImpl();
        context.setEnabledLoggingTypesMap(this.enabledLoggingTypesMap);
        return context;
    }

    public LoggingContext getContext() {
        return this.threadLocalContext.get();
    }

    protected abstract void onFlushContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushContext() {
        LoggingContext loggingContext = this.threadLocalContext.get();
        if (!loggingContext.getAllEvents().isEmpty()) {
            try {
                try {
                    this.onFlushContext();
                }
                finally {
                    this.loggingService.saveEvents(loggingContext.getAllEvents());
                }
            }
            finally {
                loggingContext.clearAllEvents();
            }
        }
    }

    public <T extends LoggableEvent> boolean isLoggingEnabled(Class<T> clazz) {
        boolean isEnabled = false;
        for (Class<? extends LoggableEvent> baseClass : this.enabledLoggingTypesMap.keySet()) {
            if (!baseClass.isAssignableFrom(clazz) || !this.enabledLoggingTypesMap.get(baseClass).booleanValue()) continue;
            isEnabled = true;
            break;
        }
        return isEnabled;
    }
}

