/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.objenesis.ObjenesisStd;
import org.unitils.core.UnitilsException;
import org.unitils.mock.proxy.ProxyInvocation;
import org.unitils.mock.proxy.ProxyInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyUtil {
    public static <T> T createProxy(Class<T> proxiedClass, ProxyInvocationHandler invocationHandler) {
        return ProxyUtil.createProxy(proxiedClass, new Class[0], invocationHandler);
    }

    public static <T> T createProxy(Class<T> proxiedClass, Class<?>[] implementedInterfaces, ProxyInvocationHandler invocationHandler) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(proxiedClass);
        if (implementedInterfaces.length != 0) {
            enhancer.setInterfaces((Class[])implementedInterfaces);
        }
        enhancer.setCallbackType(MethodInterceptor.class);
        enhancer.setUseFactory(true);
        Class enhancedTargetClass = enhancer.createClass();
        Factory proxy = (Factory)ProxyUtil.createInstanceOfType(enhancedTargetClass);
        proxy.setCallbacks(new Callback[]{new ProxyMethodInterceptor(invocationHandler)});
        return (T)proxy;
    }

    public static <T> T createInstanceOfType(Class<T> clazz) {
        ObjenesisStd objenesis = new ObjenesisStd();
        return (T)objenesis.newInstance(clazz);
    }

    public static StackTraceElement getProxiedMethodStackTraceElement(StackTraceElement[] stackTraceElements) {
        boolean foundProxyMethod = false;
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (foundProxyMethod) {
                return stackTraceElement;
            }
            if (!stackTraceElement.getClassName().contains("$$EnhancerByCGLIB$$")) continue;
            foundProxyMethod = true;
        }
        throw new UnitilsException("No invocation of a cglib proxy method found in stacktrace: " + Arrays.toString(stackTraceElements));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CglibProxyInvocation
    extends ProxyInvocation {
        private MethodProxy methodProxy;

        public CglibProxyInvocation(Method method, List<Object> arguments, StackTraceElement invokedAt, Object proxy, MethodProxy methodProxy) {
            super(proxy, method, arguments, invokedAt);
            this.methodProxy = methodProxy;
        }

        @Override
        public Object invokeOriginalBehavior() throws Throwable {
            if (Modifier.isAbstract(this.getMethod().getModifiers())) {
                throw new UnitilsException("Unable to invoke original behavior. The method is abstract, it does not have any behavior defined: " + this.getMethod());
            }
            return this.methodProxy.invokeSuper(this.getProxy(), this.getArguments().toArray());
        }
    }

    public static class ProxyMethodInterceptor
    implements MethodInterceptor {
        private ProxyInvocationHandler invocationHandler;

        public ProxyMethodInterceptor(ProxyInvocationHandler invocationHandler) {
            this.invocationHandler = invocationHandler;
        }

        public Object intercept(Object proxy, Method method, Object[] arguments, MethodProxy methodProxy) throws Throwable {
            StackTraceElement invokedAt = ProxyUtil.getProxiedMethodStackTraceElement(Thread.currentThread().getStackTrace());
            CglibProxyInvocation invocation = new CglibProxyInvocation(method, Arrays.asList(arguments), invokedAt, proxy, methodProxy);
            return this.invocationHandler.handleInvocation(invocation);
        }
    }
}

