/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.mock.Mock;
import org.unitils.mock.PartialMock;
import org.unitils.mock.annotation.AfterCreateMock;
import org.unitils.mock.annotation.Dummy;
import org.unitils.mock.core.MockObject;
import org.unitils.mock.core.Scenario;
import org.unitils.mock.dummy.DummyObjectUtil;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockModule
implements Module {
    private static Log logger = LogFactory.getLog(MockModule.class);
    public static final String PROPERTY_LOG_FULL_SCENARIO_REPORT = "mockModule.logFullScenarioReport";
    public static final String PROPERTY_LOG_OBSERVED_SCENARIO = "mockModule.logObservedScenario";
    public static final String PROPERTY_LOG_DETAILED_OBSERVED_SCENARIO = "mockModule.logDetailedObservedScenario";
    public static final String PROPERTY_LOG_SUGGESTED_ASSERTS = "mockModule.logSuggestedAsserts";
    protected Scenario scenario;
    protected boolean logFullScenarioReport;
    protected boolean logObservedScenario;
    protected boolean logDetailedObservedScenario;
    protected boolean logSuggestedAsserts;

    @Override
    public void init(Properties configuration) {
        this.logFullScenarioReport = PropertyUtils.getBoolean(PROPERTY_LOG_FULL_SCENARIO_REPORT, configuration);
        this.logObservedScenario = PropertyUtils.getBoolean(PROPERTY_LOG_OBSERVED_SCENARIO, configuration);
        this.logDetailedObservedScenario = PropertyUtils.getBoolean(PROPERTY_LOG_DETAILED_OBSERVED_SCENARIO, configuration);
        this.logSuggestedAsserts = PropertyUtils.getBoolean(PROPERTY_LOG_SUGGESTED_ASSERTS, configuration);
    }

    @Override
    public void afterInit() {
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public void assertNoMoreInvocations(StackTraceElement[] assertedAt) {
        if (this.scenario != null) {
            this.scenario.assertNoMoreInvocations(assertedAt);
        }
    }

    public void logFullScenarioReport() {
        String report = "\n\n" + this.scenario.createFullReport();
        logger.info((Object)report);
    }

    public void logObservedScenario() {
        String report = "\n\nObserved scenario:\n\n" + this.scenario.createObservedInvocationsReport();
        logger.info((Object)report);
    }

    public void logDetailedObservedScenario() {
        String report = "\n\nDetailed observed scenario:\n\n" + this.scenario.createDetailedObservedInvocationsReport();
        logger.info((Object)report);
    }

    public void logSuggestedAsserts() {
        String report = "\n\nSuggested assert statements:\n\n" + this.scenario.createSuggestedAssertsReport();
        logger.info((Object)report);
    }

    protected Mock<?> createMock(Field field, boolean partial) {
        return this.createMock(field.getName(), this.getMockedClass(field), partial);
    }

    public <T> Mock<T> createMock(String name, Class<T> type, boolean partial) {
        return new MockObject<T>(name, type, partial, this.getScenario());
    }

    protected Class<?> getMockedClass(Field field) {
        Type[] argumentTypes;
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType && (argumentTypes = ((ParameterizedType)type).getActualTypeArguments()).length == 1 && argumentTypes[0] instanceof Class) {
            return (Class)argumentTypes[0];
        }
        throw new UnitilsException("Unable to determine type of mock. A mock should be declared using the generic Mock<YourTypeToMock> or PartialMock<YourTypeToMock> types. Used type; " + type);
    }

    protected void createAndInjectMocksIntoTest(Object testObject) {
        Set<Field> mockFields = ReflectionUtils.getFieldsOfType(testObject.getClass(), Mock.class, false);
        for (Field field : mockFields) {
            Mock<?> mock = this.createMock(field, false);
            ReflectionUtils.setFieldValue(testObject, field, mock);
            this.callAfterCreateMockMethods(testObject, mock, field.getName(), field.getType());
        }
        Set<Field> partialMockFields = ReflectionUtils.getFieldsOfType(testObject.getClass(), PartialMock.class, false);
        for (Field field : partialMockFields) {
            Mock<?> mock = this.createMock(field, true);
            ReflectionUtils.setFieldValue(testObject, field, mock);
            this.callAfterCreateMockMethods(testObject, mock, field.getName(), field.getType());
        }
    }

    protected void createAndInjectDummiesIntoTest(Object testObject) {
        Set<Field> dummyFields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), Dummy.class);
        for (Field dummyField : dummyFields) {
            Object dummy = DummyObjectUtil.createDummy(dummyField.getType());
            ReflectionUtils.setFieldValue(testObject, dummyField, dummy);
        }
    }

    protected void callAfterCreateMockMethods(Object testObject, Mock<?> mockObject, String name, Class<?> type) {
        Set<Method> methods = AnnotationUtils.getMethodsAnnotatedWith(testObject.getClass(), AfterCreateMock.class);
        for (Method method : methods) {
            try {
                ReflectionUtils.invokeMethod(testObject, method, mockObject.getMock(), name, ((MockObject)mockObject).getMockedClass());
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("An exception occurred while invoking an after create mock method.", e);
            }
            catch (Exception e) {
                throw new UnitilsException("Unable to invoke after create mock method. Ensure that this method has following signature: void myMethod(Object mock, String name, Class type)", e);
            }
        }
    }

    @Override
    public TestListener getTestListener() {
        return new MockTestListener();
    }

    protected class MockTestListener
    extends TestListener {
        protected MockTestListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            MockModule.this.scenario = new Scenario(testObject);
            MockModule.this.createAndInjectMocksIntoTest(testObject);
            MockModule.this.createAndInjectDummiesIntoTest(testObject);
        }

        public void afterTestTearDown(Object testObject, Method testMethod) {
            if (MockModule.this.scenario == null) {
                return;
            }
            MockModule.this.scenario.getSyntaxMonitor().assertNotExpectingInvocation();
            if (MockModule.this.logFullScenarioReport) {
                MockModule.this.logFullScenarioReport();
                return;
            }
            if (MockModule.this.logObservedScenario) {
                MockModule.this.logObservedScenario();
            }
            if (MockModule.this.logDetailedObservedScenario) {
                MockModule.this.logDetailedObservedScenario();
            }
            if (MockModule.this.logSuggestedAsserts) {
                MockModule.this.logSuggestedAsserts();
            }
        }
    }
}

