/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.structure.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Properties;
import java.util.Set;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.dbmaintainer.structure.DataSetStructureGenerator;
import org.unitils.dbmaintainer.util.BaseDatabaseAccessor;
import org.unitils.thirdparty.org.apache.commons.io.IOUtils;
import org.unitils.util.PropertyUtils;

public class XsdDataSetStructureGenerator
extends BaseDatabaseAccessor
implements DataSetStructureGenerator {
    public static final String PROPKEY_XSD_DIR_NAME = "dataSetStructureGenerator.xsd.dirName";
    public static final String PROPKEY_XSD_COMPLEX_TYPE_SUFFIX = "dataSetStructureGenerator.xsd.complexTypeSuffix";
    private String xsdDirectoryName;
    private String complexTypeSuffix;

    protected void doInit(Properties configuration) {
        this.xsdDirectoryName = PropertyUtils.getString(PROPKEY_XSD_DIR_NAME, configuration);
        this.complexTypeSuffix = PropertyUtils.getString(PROPKEY_XSD_COMPLEX_TYPE_SUFFIX, configuration);
    }

    public void generateDataSetStructure() {
        File xsdDirectory = new File(this.xsdDirectoryName);
        xsdDirectory.mkdirs();
        this.generateDataSetXsd(xsdDirectory);
        for (DbSupport dbSupport : this.dbSupports) {
            this.generateDatabaseSchemaXsd(dbSupport, xsdDirectory);
        }
    }

    protected void generateDataSetXsd(File xsdDirectory) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(new File(xsdDirectory, "dataset.xsd")));
            String defaultSchemaName = this.defaultDbSupport.getSchemaName();
            writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            writer.write("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" xmlns:dflt=\"" + defaultSchemaName + "\">\n");
            for (DbSupport dbSupport : this.dbSupports) {
                String schemaName = dbSupport.getSchemaName();
                writer.write("\t<xsd:import namespace=\"" + schemaName + "\" schemaLocation=\"" + schemaName + ".xsd\" />\n");
            }
            writer.write("\t<xsd:element name=\"dataset\">\n");
            writer.write("\t\t<xsd:complexType>\n");
            writer.write("\t\t\t<xsd:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n");
            Set<String> defaultSchemaTableNames = this.defaultDbSupport.getTableNames();
            for (String tableName : defaultSchemaTableNames) {
                writer.write("\t\t\t\t<xsd:element name=\"" + tableName + "\" type=\"dflt:" + tableName + this.complexTypeSuffix + "\" />\n");
            }
            writer.write("\t\t\t\t<xsd:any namespace=\"" + defaultSchemaName + "\" />\n");
            writer.write("\t\t\t</xsd:choice>\n");
            writer.write("\t\t</xsd:complexType>\n");
            writer.write("\t</xsd:element>\n");
            writer.write("</xsd:schema>\n");
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error generating xsd file: " + xsdDirectory, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(writer);
    }

    protected void generateDatabaseSchemaXsd(DbSupport dbSupport, File xsdDirectory) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(new File(xsdDirectory, dbSupport.getSchemaName() + ".xsd")));
            writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            writer.write("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" xmlns=\"" + dbSupport.getSchemaName() + "\" targetNamespace=\"" + dbSupport.getSchemaName() + "\">\n");
            Set<String> tableNames = dbSupport.getTableNames();
            for (String tableName : tableNames) {
                writer.write("\t<xsd:element name=\"" + tableName + "\" type=\"" + tableName + this.complexTypeSuffix + "\" />\n");
            }
            for (String tableName : tableNames) {
                writer.write("\t<xsd:complexType name=\"" + tableName + this.complexTypeSuffix + "\">\n");
                Set<String> columnNames = dbSupport.getColumnNames(tableName);
                for (String columnName : columnNames) {
                    writer.write("\t\t<xsd:attribute name=\"" + columnName + "\" use=\"optional\" />\n");
                }
                writer.write("\t</xsd:complexType>\n");
            }
            writer.write("</xsd:schema>\n");
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error generating xsd file: " + xsdDirectory, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(writer);
    }
}

