/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.UnitilsException;
import org.unitils.thirdparty.org.apache.commons.dbutils.DbUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLUnitils {
    private static final Log logger = LogFactory.getLog(SQLUnitils.class);

    public static int executeUpdate(String sql, DataSource dataSource) {
        logger.debug((Object)sql);
        Connection connection = null;
        Statement statement = null;
        try {
            connection = dataSource.getConnection();
            statement = connection.createStatement();
            int n = statement.executeUpdate(sql);
            return n;
        }
        catch (Exception e) {
            throw new UnitilsException("Error while executing statement: " + sql, e);
        }
        finally {
            DbUtils.closeQuietly(connection, statement, null);
        }
    }

    public static int executeUpdateQuietly(String sql, DataSource dataSource) {
        try {
            return SQLUnitils.executeUpdate(sql, dataSource);
        }
        catch (UnitilsException e) {
            return -1;
        }
    }

    public static long getItemAsLong(String sql, DataSource dataSource) {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block4: {
            long l;
            logger.debug((Object)sql);
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = dataSource.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(sql);
                if (!resultSet.next()) break block4;
                l = resultSet.getLong(1);
            }
            catch (Exception e) {
                try {
                    throw new UnitilsException("Error while executing statement: " + sql, e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(connection, statement, resultSet);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly(connection, statement, resultSet);
            return l;
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
        throw new UnitilsException("No item value found: " + sql);
    }

    public static String getItemAsString(String sql, DataSource dataSource) {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block4: {
            String string;
            logger.debug((Object)sql);
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = dataSource.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(sql);
                if (!resultSet.next()) break block4;
                string = resultSet.getString(1);
            }
            catch (Exception e) {
                try {
                    throw new UnitilsException("Error while executing statement: " + sql, e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(connection, statement, resultSet);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly(connection, statement, resultSet);
            return string;
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
        throw new UnitilsException("No item value found: " + sql);
    }

    public static Set<String> getItemsAsStringSet(String sql, DataSource dataSource) {
        HashSet<String> hashSet;
        logger.debug((Object)sql);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            HashSet<String> result = new HashSet<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString(1));
            }
            hashSet = result;
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error while executing statement: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
        return hashSet;
    }

    public static boolean isEmpty(String tableName, DataSource dataSource) {
        return SQLUnitils.getItemAsLong("select count(1) from " + tableName, dataSource) == 0L;
    }
}

