/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public final class CacheSynchronization
implements Synchronization {
    private static final Log log = LogFactory.getLog((Class)CacheSynchronization.class);
    private final TransactionFactory.Context ctx;
    private JDBCContext jdbcContext;
    private final javax.transaction.Transaction transaction;
    private final Transaction hibernateTransaction;

    public CacheSynchronization(TransactionFactory.Context ctx, JDBCContext jdbcContext, javax.transaction.Transaction transaction, Transaction tx) {
        this.ctx = ctx;
        this.jdbcContext = jdbcContext;
        this.transaction = transaction;
        this.hibernateTransaction = tx;
    }

    public void beforeCompletion() {
        boolean flush;
        log.trace((Object)"transaction before completion callback");
        try {
            flush = !this.ctx.isFlushModeNever() && this.ctx.isFlushBeforeCompletionEnabled() && !JTAHelper.isRollback(this.transaction.getStatus());
        }
        catch (SystemException se) {
            log.error((Object)"could not determine transaction status", (Throwable)se);
            this.setRollbackOnly();
            throw new TransactionException("could not determine transaction status in beforeCompletion()", (Exception)((Object)se));
        }
        try {
            if (flush) {
                log.trace((Object)"automatically flushing session");
                this.ctx.managedFlush();
            }
        }
        catch (RuntimeException re) {
            this.setRollbackOnly();
            throw re;
        }
        finally {
            this.jdbcContext.beforeTransactionCompletion(this.hibernateTransaction);
        }
    }

    private void setRollbackOnly() {
        try {
            this.transaction.setRollbackOnly();
        }
        catch (SystemException se) {
            log.error((Object)"could not set transaction to rollback only", (Throwable)se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterCompletion(int status) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("transaction after completion callback, status: " + status));
        }
        try {
            this.jdbcContext.afterTransactionCompletion(status == 3, this.hibernateTransaction);
            Object var3_2 = null;
            if (!this.ctx.shouldAutoClose()) return;
            if (!this.ctx.isOpen()) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!this.ctx.shouldAutoClose() || !this.ctx.isOpen()) throw throwable;
            log.trace((Object)"automatically closing session");
            this.ctx.managedClose();
            throw throwable;
        }
        log.trace((Object)"automatically closing session");
        this.ctx.managedClose();
    }

    public String toString() {
        return CacheSynchronization.class.getName();
    }
}

