/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.RepositoryLabelIDHelper;
import com.jaspersoft.jasperserver.search.service.FolderService;
import com.jaspersoft.jasperserver.search.service.impl.BaseService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FolderServiceImpl
extends BaseService
implements FolderService {
    private static final Log log = LogFactory.getLog(FolderServiceImpl.class);

    public Folder create(String parentUri, String label, String description) {
        if (parentUri == null || label == null || description == null) {
            return null;
        }
        label = label.trim();
        description = description.trim();
        if (this.isObjectLabelExist(parentUri, label)) {
            throw new JSException("jsexception.folder.duplicate.name", new Object[]{label, parentUri});
        }
        FolderImpl folder = new FolderImpl();
        String generatedId = RepositoryLabelIDHelper.generateIdBasedOnLabel((RepositoryService)this.repositoryService, (String)parentUri, (String)label);
        folder.setParentFolder(parentUri);
        folder.setName(generatedId);
        folder.setLabel(label);
        folder.setDescription(description);
        this.repositoryService.saveFolder(null, (Folder)folder);
        return folder;
    }

    public Folder update(String folderUri, String label, String description) {
        Folder folder = this.repositoryService.getFolder(null, folderUri);
        if (this.isObjectLabelExist(folder.getParentURI(), label, folderUri)) {
            throw new JSException("jsexception.folder.duplicate.name", new Object[]{label, folder.getParentURI()});
        }
        if (!label.equalsIgnoreCase(folder.getLabel()) || !description.equalsIgnoreCase(folder.getDescription())) {
            folder.setLabel(label);
            folder.setDescription(description);
            this.repositoryService.saveFolder(null, folder);
        }
        return folder;
    }

    public void delete(String folderUri) {
        if (folderUri != null && folderUri.length() == 0) {
            return;
        }
        this.repositoryService.deleteFolder(null, folderUri);
    }

    public void copy(String folderUri, String destinationFolderUri) {
        String folderLabel;
        String parentFolderUri = destinationFolderUri;
        int lastIndex = folderUri.lastIndexOf("/");
        if (lastIndex != -1) {
            destinationFolderUri = destinationFolderUri + "/" + folderUri.substring(lastIndex + 1);
        }
        if (this.isObjectLabelExist(parentFolderUri, folderLabel = this.repositoryService.getFolder(null, folderUri).getLabel())) {
            throw new JSException("jsexception.folder.duplicate.label", new Object[]{folderLabel, parentFolderUri});
        }
        this.repositoryService.copyFolder(null, folderUri, destinationFolderUri);
    }

    public void move(String folderUri, String destinationFolderUri) {
        String folderLabel = this.repositoryService.getFolder(null, folderUri).getLabel();
        if (this.isObjectLabelExist(destinationFolderUri, folderLabel)) {
            throw new JSException("jsexception.folder.duplicate.label", new Object[]{folderLabel, destinationFolderUri});
        }
        this.repositoryService.moveFolder(null, folderUri, destinationFolderUri);
    }

    private String getParentUri(String folderUri) {
        return folderUri.substring(0, folderUri.lastIndexOf(47));
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

